package zio.aws.xray.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionStatus {
  def unwrap: software.amazon.awssdk.services.xray.model.EncryptionStatus
}
object EncryptionStatus {
  def wrap(
      value: software.amazon.awssdk.services.xray.model.EncryptionStatus
  ): zio.aws.xray.model.EncryptionStatus = value match {
    case software.amazon.awssdk.services.xray.model.EncryptionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.xray.model.EncryptionStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.xray.model.EncryptionStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion extends zio.aws.xray.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.EncryptionStatus =
      software.amazon.awssdk.services.xray.model.EncryptionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object UPDATING extends zio.aws.xray.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.EncryptionStatus =
      software.amazon.awssdk.services.xray.model.EncryptionStatus.UPDATING
  }
  case object ACTIVE extends zio.aws.xray.model.EncryptionStatus {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.EncryptionStatus =
      software.amazon.awssdk.services.xray.model.EncryptionStatus.ACTIVE
  }
}
