package zio.aws.xray.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionType {
  def unwrap: software.amazon.awssdk.services.xray.model.EncryptionType
}
object EncryptionType {
  def wrap(
      value: software.amazon.awssdk.services.xray.model.EncryptionType
  ): zio.aws.xray.model.EncryptionType = value match {
    case software.amazon.awssdk.services.xray.model.EncryptionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.xray.model.EncryptionType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.xray.model.EncryptionType.KMS =>
      val r = KMS
      r
  }
  case object unknownToSdkVersion extends zio.aws.xray.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.EncryptionType =
      software.amazon.awssdk.services.xray.model.EncryptionType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.xray.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.EncryptionType =
      software.amazon.awssdk.services.xray.model.EncryptionType.NONE
  }
  case object KMS extends zio.aws.xray.model.EncryptionType {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.EncryptionType =
      software.amazon.awssdk.services.xray.model.EncryptionType.KMS
  }
}
