package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class ErrorRootCause(
    services: Option[Iterable[zio.aws.xray.model.ErrorRootCauseService]] = None,
    clientImpacting: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ErrorRootCause = {
    import ErrorRootCause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ErrorRootCause
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(clientImpacting.map(value => value: java.lang.Boolean))(
        _.clientImpacting
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ErrorRootCause.ReadOnly =
    zio.aws.xray.model.ErrorRootCause.wrap(buildAwsValue())
}
object ErrorRootCause {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ErrorRootCause
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ErrorRootCause =
      zio.aws.xray.model.ErrorRootCause(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientImpacting.map(value => value)
      )
    def services
        : Option[List[zio.aws.xray.model.ErrorRootCauseService.ReadOnly]]
    def clientImpacting: Option[NullableBoolean]
    def getServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ErrorRootCauseService.ReadOnly
    ]] = AwsError.unwrapOptionField("services", services)
    def getClientImpacting: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("clientImpacting", clientImpacting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ErrorRootCause
  ) extends zio.aws.xray.model.ErrorRootCause.ReadOnly {
    override val services
        : Option[List[zio.aws.xray.model.ErrorRootCauseService.ReadOnly]] =
      scala
        .Option(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ErrorRootCauseService.wrap(item)
          }.toList
        )
    override val clientImpacting: Option[NullableBoolean] =
      scala.Option(impl.clientImpacting()).map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ErrorRootCause
  ): zio.aws.xray.model.ErrorRootCause.ReadOnly = new Wrapper(impl)
}
