package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class FaultRootCause(
    services: Option[Iterable[zio.aws.xray.model.FaultRootCauseService]] = None,
    clientImpacting: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.FaultRootCause = {
    import FaultRootCause.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.FaultRootCause
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(clientImpacting.map(value => value: java.lang.Boolean))(
        _.clientImpacting
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.FaultRootCause.ReadOnly =
    zio.aws.xray.model.FaultRootCause.wrap(buildAwsValue())
}
object FaultRootCause {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.FaultRootCause
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.FaultRootCause =
      zio.aws.xray.model.FaultRootCause(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientImpacting.map(value => value)
      )
    def services
        : Option[List[zio.aws.xray.model.FaultRootCauseService.ReadOnly]]
    def clientImpacting: Option[NullableBoolean]
    def getServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.FaultRootCauseService.ReadOnly
    ]] = AwsError.unwrapOptionField("services", services)
    def getClientImpacting: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("clientImpacting", clientImpacting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.FaultRootCause
  ) extends zio.aws.xray.model.FaultRootCause.ReadOnly {
    override val services
        : Option[List[zio.aws.xray.model.FaultRootCauseService.ReadOnly]] =
      scala
        .Option(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.FaultRootCauseService.wrap(item)
          }.toList
        )
    override val clientImpacting: Option[NullableBoolean] =
      scala.Option(impl.clientImpacting()).map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.FaultRootCause
  ): zio.aws.xray.model.FaultRootCause.ReadOnly = new Wrapper(impl)
}
