package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class FaultRootCauseService(
    name: Option[String] = None,
    names: Option[Iterable[String]] = None,
    `type`: Option[String] = None,
    accountId: Option[String] = None,
    entityPath: Option[Iterable[zio.aws.xray.model.FaultRootCauseEntity]] =
      None,
    inferred: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.FaultRootCauseService = {
    import FaultRootCauseService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.FaultRootCauseService
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        names.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.names)
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        entityPath.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entityPath)
      .optionallyWith(inferred.map(value => value: java.lang.Boolean))(
        _.inferred
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.FaultRootCauseService.ReadOnly =
    zio.aws.xray.model.FaultRootCauseService.wrap(buildAwsValue())
}
object FaultRootCauseService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.FaultRootCauseService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.FaultRootCauseService =
      zio.aws.xray.model.FaultRootCauseService(
        name.map(value => value),
        names.map(value => value),
        `type`.map(value => value),
        accountId.map(value => value),
        entityPath.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        inferred.map(value => value)
      )
    def name: Option[String]
    def names: Option[List[String]]
    def `type`: Option[String]
    def accountId: Option[String]
    def entityPath
        : Option[List[zio.aws.xray.model.FaultRootCauseEntity.ReadOnly]]
    def inferred: Option[NullableBoolean]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getNames: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("names", names)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getEntityPath: ZIO[Any, AwsError, List[
      zio.aws.xray.model.FaultRootCauseEntity.ReadOnly
    ]] = AwsError.unwrapOptionField("entityPath", entityPath)
    def getInferred: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("inferred", inferred)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.FaultRootCauseService
  ) extends zio.aws.xray.model.FaultRootCauseService.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val names: Option[List[String]] = scala
      .Option(impl.names())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val `type`: Option[String] =
      scala.Option(impl.`type`()).map(value => value: String)
    override val accountId: Option[String] =
      scala.Option(impl.accountId()).map(value => value: String)
    override val entityPath
        : Option[List[zio.aws.xray.model.FaultRootCauseEntity.ReadOnly]] = scala
      .Option(impl.entityPath())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.FaultRootCauseEntity.wrap(item)
        }.toList
      )
    override val inferred: Option[NullableBoolean] =
      scala.Option(impl.inferred()).map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.FaultRootCauseService
  ): zio.aws.xray.model.FaultRootCauseService.ReadOnly = new Wrapper(impl)
}
