package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetEncryptionConfigResponse(
    encryptionConfig: Option[zio.aws.xray.model.EncryptionConfig] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse = {
    import GetEncryptionConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
      .builder()
      .optionallyWith(encryptionConfig.map(value => value.buildAwsValue()))(
        _.encryptionConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly =
    zio.aws.xray.model.GetEncryptionConfigResponse.wrap(buildAwsValue())
}
object GetEncryptionConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetEncryptionConfigResponse =
      zio.aws.xray.model.GetEncryptionConfigResponse(
        encryptionConfig.map(value => value.asEditable)
      )
    def encryptionConfig: Option[zio.aws.xray.model.EncryptionConfig.ReadOnly]
    def getEncryptionConfig
        : ZIO[Any, AwsError, zio.aws.xray.model.EncryptionConfig.ReadOnly] =
      AwsError.unwrapOptionField("encryptionConfig", encryptionConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
  ) extends zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly {
    override val encryptionConfig
        : Option[zio.aws.xray.model.EncryptionConfig.ReadOnly] = scala
      .Option(impl.encryptionConfig())
      .map(value => zio.aws.xray.model.EncryptionConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetEncryptionConfigResponse
  ): zio.aws.xray.model.GetEncryptionConfigResponse.ReadOnly = new Wrapper(impl)
}
