package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{GroupARN, GroupName}
import scala.jdk.CollectionConverters._
final case class GetGroupRequest(
    groupName: Option[GroupName] = None,
    groupARN: Option[GroupARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetGroupRequest = {
    import GetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetGroupRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetGroupRequest.ReadOnly =
    zio.aws.xray.model.GetGroupRequest.wrap(buildAwsValue())
}
object GetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetGroupRequest =
      zio.aws.xray.model.GetGroupRequest(
        groupName.map(value => value),
        groupARN.map(value => value)
      )
    def groupName: Option[GroupName]
    def groupARN: Option[GroupARN]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetGroupRequest
  ) extends zio.aws.xray.model.GetGroupRequest.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val groupARN: Option[GroupARN] = scala
      .Option(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetGroupRequest
  ): zio.aws.xray.model.GetGroupRequest.ReadOnly = new Wrapper(impl)
}
