package zio.aws.xray.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{
  Token,
  GetInsightEventsMaxResults,
  InsightId
}
import scala.jdk.CollectionConverters._
final case class GetInsightEventsRequest(
    insightId: InsightId,
    maxResults: Option[GetInsightEventsMaxResults] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightEventsRequest = {
    import GetInsightEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightEventsRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .optionallyWith(
        maxResults.map(value =>
          GetInsightEventsMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightEventsRequest.ReadOnly =
    zio.aws.xray.model.GetInsightEventsRequest.wrap(buildAwsValue())
}
object GetInsightEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightEventsRequest =
      zio.aws.xray.model.GetInsightEventsRequest(
        insightId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def insightId: InsightId
    def maxResults: Option[GetInsightEventsMaxResults]
    def nextToken: Option[Token]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getMaxResults: ZIO[Any, AwsError, GetInsightEventsMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightEventsRequest
  ) extends zio.aws.xray.model.GetInsightEventsRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.xray.model.primitives.InsightId(impl.insightId())
    override val maxResults: Option[GetInsightEventsMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.xray.model.primitives.GetInsightEventsMaxResults(value)
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightEventsRequest
  ): zio.aws.xray.model.GetInsightEventsRequest.ReadOnly = new Wrapper(impl)
}
