package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{Token, Timestamp, InsightId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetInsightImpactGraphRequest(
    insightId: InsightId,
    startTime: Timestamp,
    endTime: Timestamp,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest = {
    import GetInsightImpactGraphRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightImpactGraphRequest.ReadOnly =
    zio.aws.xray.model.GetInsightImpactGraphRequest.wrap(buildAwsValue())
}
object GetInsightImpactGraphRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightImpactGraphRequest =
      zio.aws.xray.model.GetInsightImpactGraphRequest(
        insightId,
        startTime,
        endTime,
        nextToken.map(value => value)
      )
    def insightId: InsightId
    def startTime: Timestamp
    def endTime: Timestamp
    def nextToken: Option[Token]
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest
  ) extends zio.aws.xray.model.GetInsightImpactGraphRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.xray.model.primitives.InsightId(impl.insightId())
    override val startTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.endTime())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightImpactGraphRequest
  ): zio.aws.xray.model.GetInsightImpactGraphRequest.ReadOnly = new Wrapper(
    impl
  )
}
