package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{Token, Timestamp, InsightId}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetInsightImpactGraphResponse(
    insightId: Option[InsightId] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    serviceGraphStartTime: Option[Timestamp] = None,
    serviceGraphEndTime: Option[Timestamp] = None,
    services: Option[Iterable[zio.aws.xray.model.InsightImpactGraphService]] =
      None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse = {
    import GetInsightImpactGraphResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse
      .builder()
      .optionallyWith(
        insightId.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.insightId)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        serviceGraphStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.serviceGraphStartTime)
      .optionallyWith(
        serviceGraphEndTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.serviceGraphEndTime)
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly =
    zio.aws.xray.model.GetInsightImpactGraphResponse.wrap(buildAwsValue())
}
object GetInsightImpactGraphResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightImpactGraphResponse =
      zio.aws.xray.model.GetInsightImpactGraphResponse(
        insightId.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        serviceGraphStartTime.map(value => value),
        serviceGraphEndTime.map(value => value),
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def insightId: Option[InsightId]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def serviceGraphStartTime: Option[Timestamp]
    def serviceGraphEndTime: Option[Timestamp]
    def services
        : Option[List[zio.aws.xray.model.InsightImpactGraphService.ReadOnly]]
    def nextToken: Option[Token]
    def getInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("insightId", insightId)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getServiceGraphStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("serviceGraphStartTime", serviceGraphStartTime)
    def getServiceGraphEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("serviceGraphEndTime", serviceGraphEndTime)
    def getServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.InsightImpactGraphService.ReadOnly
    ]] = AwsError.unwrapOptionField("services", services)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse
  ) extends zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly {
    override val insightId: Option[InsightId] = scala
      .Option(impl.insightId())
      .map(value => zio.aws.xray.model.primitives.InsightId(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val serviceGraphStartTime: Option[Timestamp] = scala
      .Option(impl.serviceGraphStartTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val serviceGraphEndTime: Option[Timestamp] = scala
      .Option(impl.serviceGraphEndTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val services
        : Option[List[zio.aws.xray.model.InsightImpactGraphService.ReadOnly]] =
      scala
        .Option(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightImpactGraphService.wrap(item)
          }.toList
        )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.xray.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightImpactGraphResponse
  ): zio.aws.xray.model.GetInsightImpactGraphResponse.ReadOnly = new Wrapper(
    impl
  )
}
