package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.xray.model.primitives.InsightId
import scala.jdk.CollectionConverters._
final case class GetInsightRequest(insightId: InsightId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetInsightRequest = {
    import GetInsightRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetInsightRequest
      .builder()
      .insightId(InsightId.unwrap(insightId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetInsightRequest.ReadOnly =
    zio.aws.xray.model.GetInsightRequest.wrap(buildAwsValue())
}
object GetInsightRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetInsightRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetInsightRequest =
      zio.aws.xray.model.GetInsightRequest(insightId)
    def insightId: InsightId
    def getInsightId: ZIO[Any, Nothing, InsightId] = ZIO.succeed(insightId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetInsightRequest
  ) extends zio.aws.xray.model.GetInsightRequest.ReadOnly {
    override val insightId: InsightId =
      zio.aws.xray.model.primitives.InsightId(impl.insightId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetInsightRequest
  ): zio.aws.xray.model.GetInsightRequest.ReadOnly = new Wrapper(impl)
}
