package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSamplingRulesRequest(nextToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest = {
    import GetSamplingRulesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetSamplingRulesRequest.ReadOnly =
    zio.aws.xray.model.GetSamplingRulesRequest.wrap(buildAwsValue())
}
object GetSamplingRulesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingRulesRequest =
      zio.aws.xray.model.GetSamplingRulesRequest(nextToken.map(value => value))
    def nextToken: Option[String]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
  ) extends zio.aws.xray.model.GetSamplingRulesRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingRulesRequest
  ): zio.aws.xray.model.GetSamplingRulesRequest.ReadOnly = new Wrapper(impl)
}
