package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSamplingRulesResponse(
    samplingRuleRecords: Option[
      Iterable[zio.aws.xray.model.SamplingRuleRecord]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse = {
    import GetSamplingRulesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse
      .builder()
      .optionallyWith(
        samplingRuleRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.samplingRuleRecords)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly =
    zio.aws.xray.model.GetSamplingRulesResponse.wrap(buildAwsValue())
}
object GetSamplingRulesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingRulesResponse =
      zio.aws.xray.model.GetSamplingRulesResponse(
        samplingRuleRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def samplingRuleRecords
        : Option[List[zio.aws.xray.model.SamplingRuleRecord.ReadOnly]]
    def nextToken: Option[String]
    def getSamplingRuleRecords: ZIO[Any, AwsError, List[
      zio.aws.xray.model.SamplingRuleRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("samplingRuleRecords", samplingRuleRecords)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse
  ) extends zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly {
    override val samplingRuleRecords
        : Option[List[zio.aws.xray.model.SamplingRuleRecord.ReadOnly]] = scala
      .Option(impl.samplingRuleRecords())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.SamplingRuleRecord.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingRulesResponse
  ): zio.aws.xray.model.GetSamplingRulesResponse.ReadOnly = new Wrapper(impl)
}
