package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSamplingStatisticSummariesRequest(
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest = {
    import GetSamplingStatisticSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.xray.model.GetSamplingStatisticSummariesRequest.ReadOnly =
    zio.aws.xray.model.GetSamplingStatisticSummariesRequest
      .wrap(buildAwsValue())
}
object GetSamplingStatisticSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingStatisticSummariesRequest =
      zio.aws.xray.model
        .GetSamplingStatisticSummariesRequest(nextToken.map(value => value))
    def nextToken: Option[String]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest
  ) extends zio.aws.xray.model.GetSamplingStatisticSummariesRequest.ReadOnly {
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingStatisticSummariesRequest
  ): zio.aws.xray.model.GetSamplingStatisticSummariesRequest.ReadOnly =
    new Wrapper(impl)
}
