package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetSamplingTargetsResponse(
    samplingTargetDocuments: Option[
      Iterable[zio.aws.xray.model.SamplingTargetDocument]
    ] = None,
    lastRuleModification: Option[Timestamp] = None,
    unprocessedStatistics: Option[
      Iterable[zio.aws.xray.model.UnprocessedStatistics]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse = {
    import GetSamplingTargetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse
      .builder()
      .optionallyWith(
        samplingTargetDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.samplingTargetDocuments)
      .optionallyWith(
        lastRuleModification.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastRuleModification)
      .optionallyWith(
        unprocessedStatistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedStatistics)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly =
    zio.aws.xray.model.GetSamplingTargetsResponse.wrap(buildAwsValue())
}
object GetSamplingTargetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetSamplingTargetsResponse =
      zio.aws.xray.model.GetSamplingTargetsResponse(
        samplingTargetDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastRuleModification.map(value => value),
        unprocessedStatistics.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def samplingTargetDocuments
        : Option[List[zio.aws.xray.model.SamplingTargetDocument.ReadOnly]]
    def lastRuleModification: Option[Timestamp]
    def unprocessedStatistics
        : Option[List[zio.aws.xray.model.UnprocessedStatistics.ReadOnly]]
    def getSamplingTargetDocuments: ZIO[Any, AwsError, List[
      zio.aws.xray.model.SamplingTargetDocument.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "samplingTargetDocuments",
      samplingTargetDocuments
    )
    def getLastRuleModification: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastRuleModification", lastRuleModification)
    def getUnprocessedStatistics: ZIO[Any, AwsError, List[
      zio.aws.xray.model.UnprocessedStatistics.ReadOnly
    ]] =
      AwsError.unwrapOptionField("unprocessedStatistics", unprocessedStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse
  ) extends zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly {
    override val samplingTargetDocuments
        : Option[List[zio.aws.xray.model.SamplingTargetDocument.ReadOnly]] =
      scala
        .Option(impl.samplingTargetDocuments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.SamplingTargetDocument.wrap(item)
          }.toList
        )
    override val lastRuleModification: Option[Timestamp] = scala
      .Option(impl.lastRuleModification())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val unprocessedStatistics
        : Option[List[zio.aws.xray.model.UnprocessedStatistics.ReadOnly]] =
      scala
        .Option(impl.unprocessedStatistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.UnprocessedStatistics.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetSamplingTargetsResponse
  ): zio.aws.xray.model.GetSamplingTargetsResponse.ReadOnly = new Wrapper(impl)
}
