package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{GroupARN, GroupName, Timestamp}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetServiceGraphRequest(
    startTime: Timestamp,
    endTime: Timestamp,
    groupName: Option[GroupName] = None,
    groupARN: Option[GroupARN] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetServiceGraphRequest = {
    import GetServiceGraphRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetServiceGraphRequest
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetServiceGraphRequest.ReadOnly =
    zio.aws.xray.model.GetServiceGraphRequest.wrap(buildAwsValue())
}
object GetServiceGraphRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetServiceGraphRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetServiceGraphRequest =
      zio.aws.xray.model.GetServiceGraphRequest(
        startTime,
        endTime,
        groupName.map(value => value),
        groupARN.map(value => value),
        nextToken.map(value => value)
      )
    def startTime: Timestamp
    def endTime: Timestamp
    def groupName: Option[GroupName]
    def groupARN: Option[GroupARN]
    def nextToken: Option[String]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetServiceGraphRequest
  ) extends zio.aws.xray.model.GetServiceGraphRequest.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.endTime())
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val groupARN: Option[GroupARN] = scala
      .Option(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetServiceGraphRequest
  ): zio.aws.xray.model.GetServiceGraphRequest.ReadOnly = new Wrapper(impl)
}
