package zio.aws.xray.model
import java.time.Instant
import zio.aws.xray.model.primitives.{
  EntitySelectorExpression,
  Timestamp,
  GroupARN,
  GroupName,
  NullableBoolean,
  NullableInteger
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetTimeSeriesServiceStatisticsRequest(
    startTime: Timestamp,
    endTime: Timestamp,
    groupName: Option[GroupName] = None,
    groupARN: Option[GroupARN] = None,
    entitySelectorExpression: Option[EntitySelectorExpression] = None,
    period: Option[NullableInteger] = None,
    forecastStatistics: Option[NullableBoolean] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest = {
    import GetTimeSeriesServiceStatisticsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(
        entitySelectorExpression.map(value =>
          EntitySelectorExpression.unwrap(value): java.lang.String
        )
      )(_.entitySelectorExpression)
      .optionallyWith(period.map(value => value: Integer))(_.period)
      .optionallyWith(
        forecastStatistics.map(value => value: java.lang.Boolean)
      )(_.forecastStatistics)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest.ReadOnly =
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest
      .wrap(buildAwsValue())
}
object GetTimeSeriesServiceStatisticsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest =
      zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest(
        startTime,
        endTime,
        groupName.map(value => value),
        groupARN.map(value => value),
        entitySelectorExpression.map(value => value),
        period.map(value => value),
        forecastStatistics.map(value => value),
        nextToken.map(value => value)
      )
    def startTime: Timestamp
    def endTime: Timestamp
    def groupName: Option[GroupName]
    def groupARN: Option[GroupARN]
    def entitySelectorExpression: Option[EntitySelectorExpression]
    def period: Option[NullableInteger]
    def forecastStatistics: Option[NullableBoolean]
    def nextToken: Option[String]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getEntitySelectorExpression
        : ZIO[Any, AwsError, EntitySelectorExpression] = AwsError
      .unwrapOptionField("entitySelectorExpression", entitySelectorExpression)
    def getPeriod: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("period", period)
    def getForecastStatistics: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("forecastStatistics", forecastStatistics)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
  ) extends zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.endTime())
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val groupARN: Option[GroupARN] = scala
      .Option(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val entitySelectorExpression: Option[EntitySelectorExpression] =
      scala
        .Option(impl.entitySelectorExpression())
        .map(value =>
          zio.aws.xray.model.primitives.EntitySelectorExpression(value)
        )
    override val period: Option[NullableInteger] =
      scala.Option(impl.period()).map(value => value: NullableInteger)
    override val forecastStatistics: Option[NullableBoolean] = scala
      .Option(impl.forecastStatistics())
      .map(value => value: NullableBoolean)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsRequest
  ): zio.aws.xray.model.GetTimeSeriesServiceStatisticsRequest.ReadOnly =
    new Wrapper(impl)
}
