package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTimeSeriesServiceStatisticsResponse(
    timeSeriesServiceStatistics: Option[
      Iterable[zio.aws.xray.model.TimeSeriesServiceStatistics]
    ] = None,
    containsOldGroupVersions: Option[Boolean] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse = {
    import GetTimeSeriesServiceStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse
      .builder()
      .optionallyWith(
        timeSeriesServiceStatistics.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeSeriesServiceStatistics)
      .optionallyWith(
        containsOldGroupVersions.map(value => value: java.lang.Boolean)
      )(_.containsOldGroupVersions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly =
    zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse
      .wrap(buildAwsValue())
}
object GetTimeSeriesServiceStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse =
      zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse(
        timeSeriesServiceStatistics.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containsOldGroupVersions.map(value => value),
        nextToken.map(value => value)
      )
    def timeSeriesServiceStatistics
        : Option[List[zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly]]
    def containsOldGroupVersions: Option[Boolean]
    def nextToken: Option[String]
    def getTimeSeriesServiceStatistics: ZIO[Any, AwsError, List[
      zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "timeSeriesServiceStatistics",
      timeSeriesServiceStatistics
    )
    def getContainsOldGroupVersions: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("containsOldGroupVersions", containsOldGroupVersions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse
  ) extends zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly {
    override val timeSeriesServiceStatistics: Option[
      List[zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly]
    ] = scala
      .Option(impl.timeSeriesServiceStatistics())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.TimeSeriesServiceStatistics.wrap(item)
        }.toList
      )
    override val containsOldGroupVersions: Option[Boolean] =
      scala.Option(impl.containsOldGroupVersions()).map(value => value: Boolean)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTimeSeriesServiceStatisticsResponse
  ): zio.aws.xray.model.GetTimeSeriesServiceStatisticsResponse.ReadOnly =
    new Wrapper(impl)
}
