package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.TraceId
import scala.jdk.CollectionConverters._
final case class GetTraceGraphRequest(
    traceIds: Iterable[TraceId],
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTraceGraphRequest = {
    import GetTraceGraphRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTraceGraphRequest
      .builder()
      .traceIds(traceIds.map { item =>
        TraceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetTraceGraphRequest.ReadOnly =
    zio.aws.xray.model.GetTraceGraphRequest.wrap(buildAwsValue())
}
object GetTraceGraphRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTraceGraphRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTraceGraphRequest = zio.aws.xray.model
      .GetTraceGraphRequest(traceIds, nextToken.map(value => value))
    def traceIds: List[TraceId]
    def nextToken: Option[String]
    def getTraceIds: ZIO[Any, Nothing, List[TraceId]] = ZIO.succeed(traceIds)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTraceGraphRequest
  ) extends zio.aws.xray.model.GetTraceGraphRequest.ReadOnly {
    override val traceIds: List[TraceId] = impl
      .traceIds()
      .asScala
      .map { item =>
        zio.aws.xray.model.primitives.TraceId(item)
      }
      .toList
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTraceGraphRequest
  ): zio.aws.xray.model.GetTraceGraphRequest.ReadOnly = new Wrapper(impl)
}
