package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTraceGraphResponse(
    services: Option[Iterable[zio.aws.xray.model.Service]] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTraceGraphResponse = {
    import GetTraceGraphResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
      .builder()
      .optionallyWith(
        services.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.services)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetTraceGraphResponse.ReadOnly =
    zio.aws.xray.model.GetTraceGraphResponse.wrap(buildAwsValue())
}
object GetTraceGraphResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTraceGraphResponse =
      zio.aws.xray.model.GetTraceGraphResponse(
        services.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def services: Option[List[zio.aws.xray.model.Service.ReadOnly]]
    def nextToken: Option[String]
    def getServices
        : ZIO[Any, AwsError, List[zio.aws.xray.model.Service.ReadOnly]] =
      AwsError.unwrapOptionField("services", services)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
  ) extends zio.aws.xray.model.GetTraceGraphResponse.ReadOnly {
    override val services: Option[List[zio.aws.xray.model.Service.ReadOnly]] =
      scala
        .Option(impl.services())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Service.wrap(item)
          }.toList
        )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTraceGraphResponse
  ): zio.aws.xray.model.GetTraceGraphResponse.ReadOnly = new Wrapper(impl)
}
