package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{
  FilterExpression,
  NullableBoolean,
  Timestamp
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetTraceSummariesRequest(
    startTime: Timestamp,
    endTime: Timestamp,
    timeRangeType: Option[zio.aws.xray.model.TimeRangeType] = None,
    sampling: Option[NullableBoolean] = None,
    samplingStrategy: Option[zio.aws.xray.model.SamplingStrategy] = None,
    filterExpression: Option[FilterExpression] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest = {
    import GetTraceSummariesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest
      .builder()
      .startTime(Timestamp.unwrap(startTime): Instant)
      .endTime(Timestamp.unwrap(endTime): Instant)
      .optionallyWith(timeRangeType.map(value => value.unwrap))(_.timeRangeType)
      .optionallyWith(sampling.map(value => value: java.lang.Boolean))(
        _.sampling
      )
      .optionallyWith(samplingStrategy.map(value => value.buildAwsValue()))(
        _.samplingStrategy
      )
      .optionallyWith(
        filterExpression.map(value =>
          FilterExpression.unwrap(value): java.lang.String
        )
      )(_.filterExpression)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetTraceSummariesRequest.ReadOnly =
    zio.aws.xray.model.GetTraceSummariesRequest.wrap(buildAwsValue())
}
object GetTraceSummariesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTraceSummariesRequest =
      zio.aws.xray.model.GetTraceSummariesRequest(
        startTime,
        endTime,
        timeRangeType.map(value => value),
        sampling.map(value => value),
        samplingStrategy.map(value => value.asEditable),
        filterExpression.map(value => value),
        nextToken.map(value => value)
      )
    def startTime: Timestamp
    def endTime: Timestamp
    def timeRangeType: Option[zio.aws.xray.model.TimeRangeType]
    def sampling: Option[NullableBoolean]
    def samplingStrategy: Option[zio.aws.xray.model.SamplingStrategy.ReadOnly]
    def filterExpression: Option[FilterExpression]
    def nextToken: Option[String]
    def getStartTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startTime)
    def getEndTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(endTime)
    def getTimeRangeType: ZIO[Any, AwsError, zio.aws.xray.model.TimeRangeType] =
      AwsError.unwrapOptionField("timeRangeType", timeRangeType)
    def getSampling: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("sampling", sampling)
    def getSamplingStrategy
        : ZIO[Any, AwsError, zio.aws.xray.model.SamplingStrategy.ReadOnly] =
      AwsError.unwrapOptionField("samplingStrategy", samplingStrategy)
    def getFilterExpression: ZIO[Any, AwsError, FilterExpression] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest
  ) extends zio.aws.xray.model.GetTraceSummariesRequest.ReadOnly {
    override val startTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.startTime())
    override val endTime: Timestamp =
      zio.aws.xray.model.primitives.Timestamp(impl.endTime())
    override val timeRangeType: Option[zio.aws.xray.model.TimeRangeType] = scala
      .Option(impl.timeRangeType())
      .map(value => zio.aws.xray.model.TimeRangeType.wrap(value))
    override val sampling: Option[NullableBoolean] =
      scala.Option(impl.sampling()).map(value => value: NullableBoolean)
    override val samplingStrategy
        : Option[zio.aws.xray.model.SamplingStrategy.ReadOnly] = scala
      .Option(impl.samplingStrategy())
      .map(value => zio.aws.xray.model.SamplingStrategy.wrap(value))
    override val filterExpression: Option[FilterExpression] = scala
      .Option(impl.filterExpression())
      .map(value => zio.aws.xray.model.primitives.FilterExpression(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTraceSummariesRequest
  ): zio.aws.xray.model.GetTraceSummariesRequest.ReadOnly = new Wrapper(impl)
}
