package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableLong, Timestamp}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class GetTraceSummariesResponse(
    traceSummaries: Option[Iterable[zio.aws.xray.model.TraceSummary]] = None,
    approximateTime: Option[Timestamp] = None,
    tracesProcessedCount: Option[NullableLong] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse = {
    import GetTraceSummariesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
      .builder()
      .optionallyWith(
        traceSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.traceSummaries)
      .optionallyWith(
        approximateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.approximateTime)
      .optionallyWith(tracesProcessedCount.map(value => value: java.lang.Long))(
        _.tracesProcessedCount
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly =
    zio.aws.xray.model.GetTraceSummariesResponse.wrap(buildAwsValue())
}
object GetTraceSummariesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.GetTraceSummariesResponse =
      zio.aws.xray.model.GetTraceSummariesResponse(
        traceSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        approximateTime.map(value => value),
        tracesProcessedCount.map(value => value),
        nextToken.map(value => value)
      )
    def traceSummaries: Option[List[zio.aws.xray.model.TraceSummary.ReadOnly]]
    def approximateTime: Option[Timestamp]
    def tracesProcessedCount: Option[NullableLong]
    def nextToken: Option[String]
    def getTraceSummaries
        : ZIO[Any, AwsError, List[zio.aws.xray.model.TraceSummary.ReadOnly]] =
      AwsError.unwrapOptionField("traceSummaries", traceSummaries)
    def getApproximateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("approximateTime", approximateTime)
    def getTracesProcessedCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("tracesProcessedCount", tracesProcessedCount)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
  ) extends zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly {
    override val traceSummaries
        : Option[List[zio.aws.xray.model.TraceSummary.ReadOnly]] = scala
      .Option(impl.traceSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.TraceSummary.wrap(item)
        }.toList
      )
    override val approximateTime: Option[Timestamp] = scala
      .Option(impl.approximateTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val tracesProcessedCount: Option[NullableLong] = scala
      .Option(impl.tracesProcessedCount())
      .map(value => value: NullableLong)
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.GetTraceSummariesResponse
  ): zio.aws.xray.model.GetTraceSummariesResponse.ReadOnly = new Wrapper(impl)
}
