package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Group(
    groupName: Option[String] = None,
    groupARN: Option[String] = None,
    filterExpression: Option[String] = None,
    insightsConfiguration: Option[zio.aws.xray.model.InsightsConfiguration] =
      None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Group
      .builder()
      .optionallyWith(groupName.map(value => value: java.lang.String))(
        _.groupName
      )
      .optionallyWith(groupARN.map(value => value: java.lang.String))(
        _.groupARN
      )
      .optionallyWith(filterExpression.map(value => value: java.lang.String))(
        _.filterExpression
      )
      .optionallyWith(
        insightsConfiguration.map(value => value.buildAwsValue())
      )(_.insightsConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Group.ReadOnly =
    zio.aws.xray.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Group] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Group = zio.aws.xray.model.Group(
      groupName.map(value => value),
      groupARN.map(value => value),
      filterExpression.map(value => value),
      insightsConfiguration.map(value => value.asEditable)
    )
    def groupName: Option[String]
    def groupARN: Option[String]
    def filterExpression: Option[String]
    def insightsConfiguration
        : Option[zio.aws.xray.model.InsightsConfiguration.ReadOnly]
    def getGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getFilterExpression: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filterExpression", filterExpression)
    def getInsightsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.InsightsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("insightsConfiguration", insightsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Group
  ) extends zio.aws.xray.model.Group.ReadOnly {
    override val groupName: Option[String] =
      scala.Option(impl.groupName()).map(value => value: String)
    override val groupARN: Option[String] =
      scala.Option(impl.groupARN()).map(value => value: String)
    override val filterExpression: Option[String] =
      scala.Option(impl.filterExpression()).map(value => value: String)
    override val insightsConfiguration
        : Option[zio.aws.xray.model.InsightsConfiguration.ReadOnly] = scala
      .Option(impl.insightsConfiguration())
      .map(value => zio.aws.xray.model.InsightsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Group
  ): zio.aws.xray.model.Group.ReadOnly = new Wrapper(impl)
}
