package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class HistogramEntry(
    value: Option[Double] = None,
    count: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.HistogramEntry = {
    import HistogramEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.HistogramEntry
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.HistogramEntry.ReadOnly =
    zio.aws.xray.model.HistogramEntry.wrap(buildAwsValue())
}
object HistogramEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.HistogramEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.HistogramEntry = zio.aws.xray.model
      .HistogramEntry(value.map(value => value), count.map(value => value))
    def value: Option[Double]
    def count: Option[Integer]
    def getValue: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("value", value)
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.HistogramEntry
  ) extends zio.aws.xray.model.HistogramEntry.ReadOnly {
    override val value: Option[Double] =
      scala.Option(impl.value()).map(value => value: Double)
    override val count: Option[Integer] =
      scala.Option(impl.count()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.HistogramEntry
  ): zio.aws.xray.model.HistogramEntry.ReadOnly = new Wrapper(impl)
}
