package zio.aws.xray.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class Http(
    httpURL: Option[String] = None,
    httpStatus: Option[NullableInteger] = None,
    httpMethod: Option[String] = None,
    userAgent: Option[String] = None,
    clientIp: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Http = {
    import Http.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Http
      .builder()
      .optionallyWith(httpURL.map(value => value: java.lang.String))(_.httpURL)
      .optionallyWith(httpStatus.map(value => value: Integer))(_.httpStatus)
      .optionallyWith(httpMethod.map(value => value: java.lang.String))(
        _.httpMethod
      )
      .optionallyWith(userAgent.map(value => value: java.lang.String))(
        _.userAgent
      )
      .optionallyWith(clientIp.map(value => value: java.lang.String))(
        _.clientIp
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Http.ReadOnly =
    zio.aws.xray.model.Http.wrap(buildAwsValue())
}
object Http {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Http] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Http = zio.aws.xray.model.Http(
      httpURL.map(value => value),
      httpStatus.map(value => value),
      httpMethod.map(value => value),
      userAgent.map(value => value),
      clientIp.map(value => value)
    )
    def httpURL: Option[String]
    def httpStatus: Option[NullableInteger]
    def httpMethod: Option[String]
    def userAgent: Option[String]
    def clientIp: Option[String]
    def getHttpURL: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpURL", httpURL)
    def getHttpStatus: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("httpStatus", httpStatus)
    def getHttpMethod: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getUserAgent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userAgent", userAgent)
    def getClientIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientIp", clientIp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Http
  ) extends zio.aws.xray.model.Http.ReadOnly {
    override val httpURL: Option[String] =
      scala.Option(impl.httpURL()).map(value => value: String)
    override val httpStatus: Option[NullableInteger] =
      scala.Option(impl.httpStatus()).map(value => value: NullableInteger)
    override val httpMethod: Option[String] =
      scala.Option(impl.httpMethod()).map(value => value: String)
    override val userAgent: Option[String] =
      scala.Option(impl.userAgent()).map(value => value: String)
    override val clientIp: Option[String] =
      scala.Option(impl.clientIp()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Http
  ): zio.aws.xray.model.Http.ReadOnly = new Wrapper(impl)
}
