package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{
  Timestamp,
  GroupARN,
  InsightSummaryText,
  InsightId,
  GroupName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Insight(
    insightId: Option[InsightId] = None,
    groupARN: Option[GroupARN] = None,
    groupName: Option[GroupName] = None,
    rootCauseServiceId: Option[zio.aws.xray.model.ServiceId] = None,
    categories: Option[Iterable[zio.aws.xray.model.InsightCategory]] = None,
    state: Option[zio.aws.xray.model.InsightState] = None,
    startTime: Option[Timestamp] = None,
    endTime: Option[Timestamp] = None,
    summary: Option[InsightSummaryText] = None,
    clientRequestImpactStatistics: Option[
      zio.aws.xray.model.RequestImpactStatistics
    ] = None,
    rootCauseServiceRequestImpactStatistics: Option[
      zio.aws.xray.model.RequestImpactStatistics
    ] = None,
    topAnomalousServices: Option[
      Iterable[zio.aws.xray.model.AnomalousService]
    ] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Insight = {
    import Insight.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Insight
      .builder()
      .optionallyWith(
        insightId.map(value => InsightId.unwrap(value): java.lang.String)
      )(_.insightId)
      .optionallyWith(
        groupARN.map(value => GroupARN.unwrap(value): java.lang.String)
      )(_.groupARN)
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(rootCauseServiceId.map(value => value.buildAwsValue()))(
        _.rootCauseServiceId
      )
      .optionallyWith(
        categories.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.categoriesWithStrings)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(startTime.map(value => Timestamp.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => Timestamp.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        summary.map(value => InsightSummaryText.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(
        clientRequestImpactStatistics.map(value => value.buildAwsValue())
      )(_.clientRequestImpactStatistics)
      .optionallyWith(
        rootCauseServiceRequestImpactStatistics.map(value =>
          value.buildAwsValue()
        )
      )(_.rootCauseServiceRequestImpactStatistics)
      .optionallyWith(
        topAnomalousServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topAnomalousServices)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Insight.ReadOnly =
    zio.aws.xray.model.Insight.wrap(buildAwsValue())
}
object Insight {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Insight] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Insight = zio.aws.xray.model.Insight(
      insightId.map(value => value),
      groupARN.map(value => value),
      groupName.map(value => value),
      rootCauseServiceId.map(value => value.asEditable),
      categories.map(value => value),
      state.map(value => value),
      startTime.map(value => value),
      endTime.map(value => value),
      summary.map(value => value),
      clientRequestImpactStatistics.map(value => value.asEditable),
      rootCauseServiceRequestImpactStatistics.map(value => value.asEditable),
      topAnomalousServices.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def insightId: Option[InsightId]
    def groupARN: Option[GroupARN]
    def groupName: Option[GroupName]
    def rootCauseServiceId: Option[zio.aws.xray.model.ServiceId.ReadOnly]
    def categories: Option[List[zio.aws.xray.model.InsightCategory]]
    def state: Option[zio.aws.xray.model.InsightState]
    def startTime: Option[Timestamp]
    def endTime: Option[Timestamp]
    def summary: Option[InsightSummaryText]
    def clientRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def rootCauseServiceRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def topAnomalousServices
        : Option[List[zio.aws.xray.model.AnomalousService.ReadOnly]]
    def getInsightId: ZIO[Any, AwsError, InsightId] =
      AwsError.unwrapOptionField("insightId", insightId)
    def getGroupARN: ZIO[Any, AwsError, GroupARN] =
      AwsError.unwrapOptionField("groupARN", groupARN)
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getRootCauseServiceId
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceId.ReadOnly] =
      AwsError.unwrapOptionField("rootCauseServiceId", rootCauseServiceId)
    def getCategories
        : ZIO[Any, AwsError, List[zio.aws.xray.model.InsightCategory]] =
      AwsError.unwrapOptionField("categories", categories)
    def getState: ZIO[Any, AwsError, zio.aws.xray.model.InsightState] =
      AwsError.unwrapOptionField("state", state)
    def getStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSummary: ZIO[Any, AwsError, InsightSummaryText] =
      AwsError.unwrapOptionField("summary", summary)
    def getClientRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientRequestImpactStatistics",
      clientRequestImpactStatistics
    )
    def getRootCauseServiceRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootCauseServiceRequestImpactStatistics",
      rootCauseServiceRequestImpactStatistics
    )
    def getTopAnomalousServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.AnomalousService.ReadOnly
    ]] =
      AwsError.unwrapOptionField("topAnomalousServices", topAnomalousServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Insight
  ) extends zio.aws.xray.model.Insight.ReadOnly {
    override val insightId: Option[InsightId] = scala
      .Option(impl.insightId())
      .map(value => zio.aws.xray.model.primitives.InsightId(value))
    override val groupARN: Option[GroupARN] = scala
      .Option(impl.groupARN())
      .map(value => zio.aws.xray.model.primitives.GroupARN(value))
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.xray.model.primitives.GroupName(value))
    override val rootCauseServiceId
        : Option[zio.aws.xray.model.ServiceId.ReadOnly] = scala
      .Option(impl.rootCauseServiceId())
      .map(value => zio.aws.xray.model.ServiceId.wrap(value))
    override val categories: Option[List[zio.aws.xray.model.InsightCategory]] =
      scala
        .Option(impl.categories())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.InsightCategory.wrap(item)
          }.toList
        )
    override val state: Option[zio.aws.xray.model.InsightState] = scala
      .Option(impl.state())
      .map(value => zio.aws.xray.model.InsightState.wrap(value))
    override val startTime: Option[Timestamp] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val endTime: Option[Timestamp] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val summary: Option[InsightSummaryText] = scala
      .Option(impl.summary())
      .map(value => zio.aws.xray.model.primitives.InsightSummaryText(value))
    override val clientRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] = scala
      .Option(impl.clientRequestImpactStatistics())
      .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val rootCauseServiceRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] = scala
      .Option(impl.rootCauseServiceRequestImpactStatistics())
      .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val topAnomalousServices
        : Option[List[zio.aws.xray.model.AnomalousService.ReadOnly]] = scala
      .Option(impl.topAnomalousServices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.AnomalousService.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Insight
  ): zio.aws.xray.model.Insight.ReadOnly = new Wrapper(impl)
}
