package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{Timestamp, EventSummaryText}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class InsightEvent(
    summary: Option[EventSummaryText] = None,
    eventTime: Option[Timestamp] = None,
    clientRequestImpactStatistics: Option[
      zio.aws.xray.model.RequestImpactStatistics
    ] = None,
    rootCauseServiceRequestImpactStatistics: Option[
      zio.aws.xray.model.RequestImpactStatistics
    ] = None,
    topAnomalousServices: Option[
      Iterable[zio.aws.xray.model.AnomalousService]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.InsightEvent = {
    import InsightEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.InsightEvent
      .builder()
      .optionallyWith(
        summary.map(value => EventSummaryText.unwrap(value): java.lang.String)
      )(_.summary)
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        clientRequestImpactStatistics.map(value => value.buildAwsValue())
      )(_.clientRequestImpactStatistics)
      .optionallyWith(
        rootCauseServiceRequestImpactStatistics.map(value =>
          value.buildAwsValue()
        )
      )(_.rootCauseServiceRequestImpactStatistics)
      .optionallyWith(
        topAnomalousServices.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topAnomalousServices)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.InsightEvent.ReadOnly =
    zio.aws.xray.model.InsightEvent.wrap(buildAwsValue())
}
object InsightEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.InsightEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.InsightEvent =
      zio.aws.xray.model.InsightEvent(
        summary.map(value => value),
        eventTime.map(value => value),
        clientRequestImpactStatistics.map(value => value.asEditable),
        rootCauseServiceRequestImpactStatistics.map(value => value.asEditable),
        topAnomalousServices.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def summary: Option[EventSummaryText]
    def eventTime: Option[Timestamp]
    def clientRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def rootCauseServiceRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly]
    def topAnomalousServices
        : Option[List[zio.aws.xray.model.AnomalousService.ReadOnly]]
    def getSummary: ZIO[Any, AwsError, EventSummaryText] =
      AwsError.unwrapOptionField("summary", summary)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getClientRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "clientRequestImpactStatistics",
      clientRequestImpactStatistics
    )
    def getRootCauseServiceRequestImpactStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.xray.model.RequestImpactStatistics.ReadOnly
    ] = AwsError.unwrapOptionField(
      "rootCauseServiceRequestImpactStatistics",
      rootCauseServiceRequestImpactStatistics
    )
    def getTopAnomalousServices: ZIO[Any, AwsError, List[
      zio.aws.xray.model.AnomalousService.ReadOnly
    ]] =
      AwsError.unwrapOptionField("topAnomalousServices", topAnomalousServices)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.InsightEvent
  ) extends zio.aws.xray.model.InsightEvent.ReadOnly {
    override val summary: Option[EventSummaryText] = scala
      .Option(impl.summary())
      .map(value => zio.aws.xray.model.primitives.EventSummaryText(value))
    override val eventTime: Option[Timestamp] = scala
      .Option(impl.eventTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val clientRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] = scala
      .Option(impl.clientRequestImpactStatistics())
      .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val rootCauseServiceRequestImpactStatistics
        : Option[zio.aws.xray.model.RequestImpactStatistics.ReadOnly] = scala
      .Option(impl.rootCauseServiceRequestImpactStatistics())
      .map(value => zio.aws.xray.model.RequestImpactStatistics.wrap(value))
    override val topAnomalousServices
        : Option[List[zio.aws.xray.model.AnomalousService.ReadOnly]] = scala
      .Option(impl.topAnomalousServices())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.AnomalousService.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.InsightEvent
  ): zio.aws.xray.model.InsightEvent.ReadOnly = new Wrapper(impl)
}
