package zio.aws.xray.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableInteger
import scala.jdk.CollectionConverters._
final case class InsightImpactGraphEdge(
    referenceId: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge = {
    import InsightImpactGraphEdge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge
      .builder()
      .optionallyWith(referenceId.map(value => value: Integer))(_.referenceId)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.InsightImpactGraphEdge.ReadOnly =
    zio.aws.xray.model.InsightImpactGraphEdge.wrap(buildAwsValue())
}
object InsightImpactGraphEdge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.InsightImpactGraphEdge =
      zio.aws.xray.model.InsightImpactGraphEdge(referenceId.map(value => value))
    def referenceId: Option[NullableInteger]
    def getReferenceId: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("referenceId", referenceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge
  ) extends zio.aws.xray.model.InsightImpactGraphEdge.ReadOnly {
    override val referenceId: Option[NullableInteger] =
      scala.Option(impl.referenceId()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.InsightImpactGraphEdge
  ): zio.aws.xray.model.InsightImpactGraphEdge.ReadOnly = new Wrapper(impl)
}
