package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableBoolean
import scala.jdk.CollectionConverters._
final case class InsightsConfiguration(
    insightsEnabled: Option[NullableBoolean] = None,
    notificationsEnabled: Option[NullableBoolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.InsightsConfiguration = {
    import InsightsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.InsightsConfiguration
      .builder()
      .optionallyWith(insightsEnabled.map(value => value: java.lang.Boolean))(
        _.insightsEnabled
      )
      .optionallyWith(
        notificationsEnabled.map(value => value: java.lang.Boolean)
      )(_.notificationsEnabled)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.InsightsConfiguration.ReadOnly =
    zio.aws.xray.model.InsightsConfiguration.wrap(buildAwsValue())
}
object InsightsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.InsightsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.InsightsConfiguration =
      zio.aws.xray.model.InsightsConfiguration(
        insightsEnabled.map(value => value),
        notificationsEnabled.map(value => value)
      )
    def insightsEnabled: Option[NullableBoolean]
    def notificationsEnabled: Option[NullableBoolean]
    def getInsightsEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("insightsEnabled", insightsEnabled)
    def getNotificationsEnabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("notificationsEnabled", notificationsEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.InsightsConfiguration
  ) extends zio.aws.xray.model.InsightsConfiguration.ReadOnly {
    override val insightsEnabled: Option[NullableBoolean] =
      scala.Option(impl.insightsEnabled()).map(value => value: NullableBoolean)
    override val notificationsEnabled: Option[NullableBoolean] = scala
      .Option(impl.notificationsEnabled())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.InsightsConfiguration
  ): zio.aws.xray.model.InsightsConfiguration.ReadOnly = new Wrapper(impl)
}
