package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceIdDetail(id: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.InstanceIdDetail = {
    import InstanceIdDetail.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.InstanceIdDetail
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.InstanceIdDetail.ReadOnly =
    zio.aws.xray.model.InstanceIdDetail.wrap(buildAwsValue())
}
object InstanceIdDetail {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.InstanceIdDetail
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.InstanceIdDetail =
      zio.aws.xray.model.InstanceIdDetail(id.map(value => value))
    def id: Option[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.InstanceIdDetail
  ) extends zio.aws.xray.model.InstanceIdDetail.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.InstanceIdDetail
  ): zio.aws.xray.model.InstanceIdDetail.ReadOnly = new Wrapper(impl)
}
