package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.EncryptionKeyId
import scala.jdk.CollectionConverters._
final case class PutEncryptionConfigRequest(
    keyId: Option[EncryptionKeyId] = None,
    `type`: zio.aws.xray.model.EncryptionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest = {
    import PutEncryptionConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest
      .builder()
      .optionallyWith(
        keyId.map(value => EncryptionKeyId.unwrap(value): java.lang.String)
      )(_.keyId)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.PutEncryptionConfigRequest.ReadOnly =
    zio.aws.xray.model.PutEncryptionConfigRequest.wrap(buildAwsValue())
}
object PutEncryptionConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.PutEncryptionConfigRequest =
      zio.aws.xray.model
        .PutEncryptionConfigRequest(keyId.map(value => value), `type`)
    def keyId: Option[EncryptionKeyId]
    def `type`: zio.aws.xray.model.EncryptionType
    def getKeyId: ZIO[Any, AwsError, EncryptionKeyId] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getType: ZIO[Any, Nothing, zio.aws.xray.model.EncryptionType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest
  ) extends zio.aws.xray.model.PutEncryptionConfigRequest.ReadOnly {
    override val keyId: Option[EncryptionKeyId] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.xray.model.primitives.EncryptionKeyId(value))
    override val `type`: zio.aws.xray.model.EncryptionType =
      zio.aws.xray.model.EncryptionType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.PutEncryptionConfigRequest
  ): zio.aws.xray.model.PutEncryptionConfigRequest.ReadOnly = new Wrapper(impl)
}
