package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{ResourceARN, Hostname, EC2InstanceId}
import scala.jdk.CollectionConverters._
final case class PutTelemetryRecordsRequest(
    telemetryRecords: Iterable[zio.aws.xray.model.TelemetryRecord],
    ec2InstanceId: Option[EC2InstanceId] = None,
    hostname: Option[Hostname] = None,
    resourceARN: Option[ResourceARN] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest = {
    import PutTelemetryRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest
      .builder()
      .telemetryRecords(telemetryRecords.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        ec2InstanceId.map(value =>
          EC2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        hostname.map(value => Hostname.unwrap(value): java.lang.String)
      )(_.hostname)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.PutTelemetryRecordsRequest.ReadOnly =
    zio.aws.xray.model.PutTelemetryRecordsRequest.wrap(buildAwsValue())
}
object PutTelemetryRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.PutTelemetryRecordsRequest =
      zio.aws.xray.model.PutTelemetryRecordsRequest(
        telemetryRecords.map { item =>
          item.asEditable
        },
        ec2InstanceId.map(value => value),
        hostname.map(value => value),
        resourceARN.map(value => value)
      )
    def telemetryRecords: List[zio.aws.xray.model.TelemetryRecord.ReadOnly]
    def ec2InstanceId: Option[EC2InstanceId]
    def hostname: Option[Hostname]
    def resourceARN: Option[ResourceARN]
    def getTelemetryRecords
        : ZIO[Any, Nothing, List[zio.aws.xray.model.TelemetryRecord.ReadOnly]] =
      ZIO.succeed(telemetryRecords)
    def getEc2InstanceId: ZIO[Any, AwsError, EC2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getHostname: ZIO[Any, AwsError, Hostname] =
      AwsError.unwrapOptionField("hostname", hostname)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest
  ) extends zio.aws.xray.model.PutTelemetryRecordsRequest.ReadOnly {
    override val telemetryRecords
        : List[zio.aws.xray.model.TelemetryRecord.ReadOnly] = impl
      .telemetryRecords()
      .asScala
      .map { item =>
        zio.aws.xray.model.TelemetryRecord.wrap(item)
      }
      .toList
    override val ec2InstanceId: Option[EC2InstanceId] = scala
      .Option(impl.ec2InstanceId())
      .map(value => zio.aws.xray.model.primitives.EC2InstanceId(value))
    override val hostname: Option[Hostname] = scala
      .Option(impl.hostname())
      .map(value => zio.aws.xray.model.primitives.Hostname(value))
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.xray.model.primitives.ResourceARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.PutTelemetryRecordsRequest
  ): zio.aws.xray.model.PutTelemetryRecordsRequest.ReadOnly = new Wrapper(impl)
}
