package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.xray.model.primitives.TraceSegmentDocument
import scala.jdk.CollectionConverters._
final case class PutTraceSegmentsRequest(
    traceSegmentDocuments: Iterable[TraceSegmentDocument]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest = {
    import PutTraceSegmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest
      .builder()
      .traceSegmentDocuments(traceSegmentDocuments.map { item =>
        TraceSegmentDocument.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.PutTraceSegmentsRequest.ReadOnly =
    zio.aws.xray.model.PutTraceSegmentsRequest.wrap(buildAwsValue())
}
object PutTraceSegmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.PutTraceSegmentsRequest =
      zio.aws.xray.model.PutTraceSegmentsRequest(traceSegmentDocuments)
    def traceSegmentDocuments: List[TraceSegmentDocument]
    def getTraceSegmentDocuments
        : ZIO[Any, Nothing, List[TraceSegmentDocument]] =
      ZIO.succeed(traceSegmentDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest
  ) extends zio.aws.xray.model.PutTraceSegmentsRequest.ReadOnly {
    override val traceSegmentDocuments: List[TraceSegmentDocument] = impl
      .traceSegmentDocuments()
      .asScala
      .map { item =>
        zio.aws.xray.model.primitives.TraceSegmentDocument(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.PutTraceSegmentsRequest
  ): zio.aws.xray.model.PutTraceSegmentsRequest.ReadOnly = new Wrapper(impl)
}
