package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutTraceSegmentsResponse(
    unprocessedTraceSegments: Option[
      Iterable[zio.aws.xray.model.UnprocessedTraceSegment]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse = {
    import PutTraceSegmentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse
      .builder()
      .optionallyWith(
        unprocessedTraceSegments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedTraceSegments)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly =
    zio.aws.xray.model.PutTraceSegmentsResponse.wrap(buildAwsValue())
}
object PutTraceSegmentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.PutTraceSegmentsResponse =
      zio.aws.xray.model.PutTraceSegmentsResponse(
        unprocessedTraceSegments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def unprocessedTraceSegments
        : Option[List[zio.aws.xray.model.UnprocessedTraceSegment.ReadOnly]]
    def getUnprocessedTraceSegments: ZIO[Any, AwsError, List[
      zio.aws.xray.model.UnprocessedTraceSegment.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedTraceSegments",
      unprocessedTraceSegments
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse
  ) extends zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly {
    override val unprocessedTraceSegments
        : Option[List[zio.aws.xray.model.UnprocessedTraceSegment.ReadOnly]] =
      scala
        .Option(impl.unprocessedTraceSegments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.UnprocessedTraceSegment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.PutTraceSegmentsResponse
  ): zio.aws.xray.model.PutTraceSegmentsResponse.ReadOnly = new Wrapper(impl)
}
