package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RootCauseException(
    name: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.RootCauseException = {
    import RootCauseException.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.RootCauseException
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.RootCauseException.ReadOnly =
    zio.aws.xray.model.RootCauseException.wrap(buildAwsValue())
}
object RootCauseException {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.RootCauseException
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.RootCauseException = zio.aws.xray.model
      .RootCauseException(name.map(value => value), message.map(value => value))
    def name: Option[String]
    def message: Option[String]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.RootCauseException
  ) extends zio.aws.xray.model.RootCauseException.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.RootCauseException
  ): zio.aws.xray.model.RootCauseException.ReadOnly = new Wrapper(impl)
}
