package zio.aws.xray.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{
  Host,
  ReservoirSize,
  Priority,
  ServiceType,
  HTTPMethod,
  RuleName,
  ResourceARN,
  Version,
  FixedRate,
  AttributeKey,
  ServiceName,
  AttributeValue,
  URLPath
}
import scala.jdk.CollectionConverters._
final case class SamplingRule(
    ruleName: Option[RuleName] = None,
    ruleARN: Option[String] = None,
    resourceARN: ResourceARN,
    priority: Priority,
    fixedRate: FixedRate,
    reservoirSize: ReservoirSize,
    serviceName: ServiceName,
    serviceType: ServiceType,
    host: Host,
    httpMethod: HTTPMethod,
    urlPath: URLPath,
    version: Version,
    attributes: Option[Map[AttributeKey, AttributeValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingRule = {
    import SamplingRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingRule
      .builder()
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(ruleARN.map(value => value: java.lang.String))(_.ruleARN)
      .resourceARN(ResourceARN.unwrap(resourceARN): java.lang.String)
      .priority(Priority.unwrap(priority): Integer)
      .fixedRate(FixedRate.unwrap(fixedRate): java.lang.Double)
      .reservoirSize(ReservoirSize.unwrap(reservoirSize): Integer)
      .serviceName(ServiceName.unwrap(serviceName): java.lang.String)
      .serviceType(ServiceType.unwrap(serviceType): java.lang.String)
      .host(Host.unwrap(host): java.lang.String)
      .httpMethod(HTTPMethod.unwrap(httpMethod): java.lang.String)
      .urlPath(URLPath.unwrap(urlPath): java.lang.String)
      .version(Version.unwrap(version): Integer)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingRule.ReadOnly =
    zio.aws.xray.model.SamplingRule.wrap(buildAwsValue())
}
object SamplingRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.SamplingRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingRule =
      zio.aws.xray.model.SamplingRule(
        ruleName.map(value => value),
        ruleARN.map(value => value),
        resourceARN,
        priority,
        fixedRate,
        reservoirSize,
        serviceName,
        serviceType,
        host,
        httpMethod,
        urlPath,
        version,
        attributes.map(value => value)
      )
    def ruleName: Option[RuleName]
    def ruleARN: Option[String]
    def resourceARN: ResourceARN
    def priority: Priority
    def fixedRate: FixedRate
    def reservoirSize: ReservoirSize
    def serviceName: ServiceName
    def serviceType: ServiceType
    def host: Host
    def httpMethod: HTTPMethod
    def urlPath: URLPath
    def version: Version
    def attributes: Option[Map[AttributeKey, AttributeValue]]
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleARN", ruleARN)
    def getResourceARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceARN)
    def getPriority: ZIO[Any, Nothing, Priority] = ZIO.succeed(priority)
    def getFixedRate: ZIO[Any, Nothing, FixedRate] = ZIO.succeed(fixedRate)
    def getReservoirSize: ZIO[Any, Nothing, ReservoirSize] =
      ZIO.succeed(reservoirSize)
    def getServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(serviceName)
    def getServiceType: ZIO[Any, Nothing, ServiceType] =
      ZIO.succeed(serviceType)
    def getHost: ZIO[Any, Nothing, Host] = ZIO.succeed(host)
    def getHttpMethod: ZIO[Any, Nothing, HTTPMethod] = ZIO.succeed(httpMethod)
    def getUrlPath: ZIO[Any, Nothing, URLPath] = ZIO.succeed(urlPath)
    def getVersion: ZIO[Any, Nothing, Version] = ZIO.succeed(version)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeKey, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingRule
  ) extends zio.aws.xray.model.SamplingRule.ReadOnly {
    override val ruleName: Option[RuleName] = scala
      .Option(impl.ruleName())
      .map(value => zio.aws.xray.model.primitives.RuleName(value))
    override val ruleARN: Option[String] =
      scala.Option(impl.ruleARN()).map(value => value: String)
    override val resourceARN: ResourceARN =
      zio.aws.xray.model.primitives.ResourceARN(impl.resourceARN())
    override val priority: Priority =
      zio.aws.xray.model.primitives.Priority(impl.priority())
    override val fixedRate: FixedRate =
      zio.aws.xray.model.primitives.FixedRate(impl.fixedRate())
    override val reservoirSize: ReservoirSize =
      zio.aws.xray.model.primitives.ReservoirSize(impl.reservoirSize())
    override val serviceName: ServiceName =
      zio.aws.xray.model.primitives.ServiceName(impl.serviceName())
    override val serviceType: ServiceType =
      zio.aws.xray.model.primitives.ServiceType(impl.serviceType())
    override val host: Host = zio.aws.xray.model.primitives.Host(impl.host())
    override val httpMethod: HTTPMethod =
      zio.aws.xray.model.primitives.HTTPMethod(impl.httpMethod())
    override val urlPath: URLPath =
      zio.aws.xray.model.primitives.URLPath(impl.urlPath())
    override val version: Version =
      zio.aws.xray.model.primitives.Version(impl.version())
    override val attributes: Option[Map[AttributeKey, AttributeValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.xray.model.primitives.AttributeKey(
              key
            ) -> zio.aws.xray.model.primitives.AttributeValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingRule
  ): zio.aws.xray.model.SamplingRule.ReadOnly = new Wrapper(impl)
}
