package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SamplingRuleRecord(
    samplingRule: Option[zio.aws.xray.model.SamplingRule] = None,
    createdAt: Option[Timestamp] = None,
    modifiedAt: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingRuleRecord = {
    import SamplingRuleRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingRuleRecord
      .builder()
      .optionallyWith(samplingRule.map(value => value.buildAwsValue()))(
        _.samplingRule
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        modifiedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.modifiedAt)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingRuleRecord.ReadOnly =
    zio.aws.xray.model.SamplingRuleRecord.wrap(buildAwsValue())
}
object SamplingRuleRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingRuleRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingRuleRecord =
      zio.aws.xray.model.SamplingRuleRecord(
        samplingRule.map(value => value.asEditable),
        createdAt.map(value => value),
        modifiedAt.map(value => value)
      )
    def samplingRule: Option[zio.aws.xray.model.SamplingRule.ReadOnly]
    def createdAt: Option[Timestamp]
    def modifiedAt: Option[Timestamp]
    def getSamplingRule
        : ZIO[Any, AwsError, zio.aws.xray.model.SamplingRule.ReadOnly] =
      AwsError.unwrapOptionField("samplingRule", samplingRule)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getModifiedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("modifiedAt", modifiedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingRuleRecord
  ) extends zio.aws.xray.model.SamplingRuleRecord.ReadOnly {
    override val samplingRule
        : Option[zio.aws.xray.model.SamplingRule.ReadOnly] = scala
      .Option(impl.samplingRule())
      .map(value => zio.aws.xray.model.SamplingRule.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val modifiedAt: Option[Timestamp] = scala
      .Option(impl.modifiedAt())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingRuleRecord
  ): zio.aws.xray.model.SamplingRuleRecord.ReadOnly = new Wrapper(impl)
}
