package zio.aws.xray.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{
  Host,
  ServiceType,
  NullableDouble,
  HTTPMethod,
  RuleName,
  ResourceARN,
  AttributeKey,
  ServiceName,
  NullableInteger,
  AttributeValue,
  URLPath
}
import scala.jdk.CollectionConverters._
final case class SamplingRuleUpdate(
    ruleName: Option[RuleName] = None,
    ruleARN: Option[String] = None,
    resourceARN: Option[ResourceARN] = None,
    priority: Option[NullableInteger] = None,
    fixedRate: Option[NullableDouble] = None,
    reservoirSize: Option[NullableInteger] = None,
    host: Option[Host] = None,
    serviceName: Option[ServiceName] = None,
    serviceType: Option[ServiceType] = None,
    httpMethod: Option[HTTPMethod] = None,
    urlPath: Option[URLPath] = None,
    attributes: Option[Map[AttributeKey, AttributeValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingRuleUpdate = {
    import SamplingRuleUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
      .builder()
      .optionallyWith(
        ruleName.map(value => RuleName.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(ruleARN.map(value => value: java.lang.String))(_.ruleARN)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(priority.map(value => value: Integer))(_.priority)
      .optionallyWith(fixedRate.map(value => value: java.lang.Double))(
        _.fixedRate
      )
      .optionallyWith(reservoirSize.map(value => value: Integer))(
        _.reservoirSize
      )
      .optionallyWith(host.map(value => Host.unwrap(value): java.lang.String))(
        _.host
      )
      .optionallyWith(
        serviceName.map(value => ServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(
        serviceType.map(value => ServiceType.unwrap(value): java.lang.String)
      )(_.serviceType)
      .optionallyWith(
        httpMethod.map(value => HTTPMethod.unwrap(value): java.lang.String)
      )(_.httpMethod)
      .optionallyWith(
        urlPath.map(value => URLPath.unwrap(value): java.lang.String)
      )(_.urlPath)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingRuleUpdate.ReadOnly =
    zio.aws.xray.model.SamplingRuleUpdate.wrap(buildAwsValue())
}
object SamplingRuleUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingRuleUpdate =
      zio.aws.xray.model.SamplingRuleUpdate(
        ruleName.map(value => value),
        ruleARN.map(value => value),
        resourceARN.map(value => value),
        priority.map(value => value),
        fixedRate.map(value => value),
        reservoirSize.map(value => value),
        host.map(value => value),
        serviceName.map(value => value),
        serviceType.map(value => value),
        httpMethod.map(value => value),
        urlPath.map(value => value),
        attributes.map(value => value)
      )
    def ruleName: Option[RuleName]
    def ruleARN: Option[String]
    def resourceARN: Option[ResourceARN]
    def priority: Option[NullableInteger]
    def fixedRate: Option[NullableDouble]
    def reservoirSize: Option[NullableInteger]
    def host: Option[Host]
    def serviceName: Option[ServiceName]
    def serviceType: Option[ServiceType]
    def httpMethod: Option[HTTPMethod]
    def urlPath: Option[URLPath]
    def attributes: Option[Map[AttributeKey, AttributeValue]]
    def getRuleName: ZIO[Any, AwsError, RuleName] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getRuleARN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleARN", ruleARN)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getPriority: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("priority", priority)
    def getFixedRate: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("fixedRate", fixedRate)
    def getReservoirSize: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("reservoirSize", reservoirSize)
    def getHost: ZIO[Any, AwsError, Host] =
      AwsError.unwrapOptionField("host", host)
    def getServiceName: ZIO[Any, AwsError, ServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getServiceType: ZIO[Any, AwsError, ServiceType] =
      AwsError.unwrapOptionField("serviceType", serviceType)
    def getHttpMethod: ZIO[Any, AwsError, HTTPMethod] =
      AwsError.unwrapOptionField("httpMethod", httpMethod)
    def getUrlPath: ZIO[Any, AwsError, URLPath] =
      AwsError.unwrapOptionField("urlPath", urlPath)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeKey, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
  ) extends zio.aws.xray.model.SamplingRuleUpdate.ReadOnly {
    override val ruleName: Option[RuleName] = scala
      .Option(impl.ruleName())
      .map(value => zio.aws.xray.model.primitives.RuleName(value))
    override val ruleARN: Option[String] =
      scala.Option(impl.ruleARN()).map(value => value: String)
    override val resourceARN: Option[ResourceARN] = scala
      .Option(impl.resourceARN())
      .map(value => zio.aws.xray.model.primitives.ResourceARN(value))
    override val priority: Option[NullableInteger] =
      scala.Option(impl.priority()).map(value => value: NullableInteger)
    override val fixedRate: Option[NullableDouble] =
      scala.Option(impl.fixedRate()).map(value => value: NullableDouble)
    override val reservoirSize: Option[NullableInteger] =
      scala.Option(impl.reservoirSize()).map(value => value: NullableInteger)
    override val host: Option[Host] = scala
      .Option(impl.host())
      .map(value => zio.aws.xray.model.primitives.Host(value))
    override val serviceName: Option[ServiceName] = scala
      .Option(impl.serviceName())
      .map(value => zio.aws.xray.model.primitives.ServiceName(value))
    override val serviceType: Option[ServiceType] = scala
      .Option(impl.serviceType())
      .map(value => zio.aws.xray.model.primitives.ServiceType(value))
    override val httpMethod: Option[HTTPMethod] = scala
      .Option(impl.httpMethod())
      .map(value => zio.aws.xray.model.primitives.HTTPMethod(value))
    override val urlPath: Option[URLPath] = scala
      .Option(impl.urlPath())
      .map(value => zio.aws.xray.model.primitives.URLPath(value))
    override val attributes: Option[Map[AttributeKey, AttributeValue]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.xray.model.primitives.AttributeKey(
              key
            ) -> zio.aws.xray.model.primitives.AttributeValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingRuleUpdate
  ): zio.aws.xray.model.SamplingRuleUpdate.ReadOnly = new Wrapper(impl)
}
