package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{Integer, Timestamp}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SamplingStatisticSummary(
    ruleName: Option[String] = None,
    timestamp: Option[Timestamp] = None,
    requestCount: Option[Integer] = None,
    borrowCount: Option[Integer] = None,
    sampledCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingStatisticSummary = {
    import SamplingStatisticSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(requestCount.map(value => value: java.lang.Integer))(
        _.requestCount
      )
      .optionallyWith(borrowCount.map(value => value: java.lang.Integer))(
        _.borrowCount
      )
      .optionallyWith(sampledCount.map(value => value: java.lang.Integer))(
        _.sampledCount
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingStatisticSummary.ReadOnly =
    zio.aws.xray.model.SamplingStatisticSummary.wrap(buildAwsValue())
}
object SamplingStatisticSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingStatisticSummary =
      zio.aws.xray.model.SamplingStatisticSummary(
        ruleName.map(value => value),
        timestamp.map(value => value),
        requestCount.map(value => value),
        borrowCount.map(value => value),
        sampledCount.map(value => value)
      )
    def ruleName: Option[String]
    def timestamp: Option[Timestamp]
    def requestCount: Option[Integer]
    def borrowCount: Option[Integer]
    def sampledCount: Option[Integer]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getRequestCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("requestCount", requestCount)
    def getBorrowCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("borrowCount", borrowCount)
    def getSampledCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sampledCount", sampledCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
  ) extends zio.aws.xray.model.SamplingStatisticSummary.ReadOnly {
    override val ruleName: Option[String] =
      scala.Option(impl.ruleName()).map(value => value: String)
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val requestCount: Option[Integer] =
      scala.Option(impl.requestCount()).map(value => value: Integer)
    override val borrowCount: Option[Integer] =
      scala.Option(impl.borrowCount()).map(value => value: Integer)
    override val sampledCount: Option[Integer] =
      scala.Option(impl.sampledCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingStatisticSummary
  ): zio.aws.xray.model.SamplingStatisticSummary.ReadOnly = new Wrapper(impl)
}
