package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.NullableDouble
import scala.jdk.CollectionConverters._
final case class SamplingStrategy(
    name: Option[zio.aws.xray.model.SamplingStrategyName] = None,
    value: Option[NullableDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingStrategy = {
    import SamplingStrategy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingStrategy
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(value.map(value => value: java.lang.Double))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingStrategy.ReadOnly =
    zio.aws.xray.model.SamplingStrategy.wrap(buildAwsValue())
}
object SamplingStrategy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingStrategy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingStrategy = zio.aws.xray.model
      .SamplingStrategy(name.map(value => value), value.map(value => value))
    def name: Option[zio.aws.xray.model.SamplingStrategyName]
    def value: Option[NullableDouble]
    def getName: ZIO[Any, AwsError, zio.aws.xray.model.SamplingStrategyName] =
      AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingStrategy
  ) extends zio.aws.xray.model.SamplingStrategy.ReadOnly {
    override val name: Option[zio.aws.xray.model.SamplingStrategyName] = scala
      .Option(impl.name())
      .map(value => zio.aws.xray.model.SamplingStrategyName.wrap(value))
    override val value: Option[NullableDouble] =
      scala.Option(impl.value()).map(value => value: NullableDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingStrategy
  ): zio.aws.xray.model.SamplingStrategy.ReadOnly = new Wrapper(impl)
}
