package zio.aws.xray.model
import java.time.Instant
import zio.aws.xray.model.primitives.{Timestamp, NullableInteger}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SamplingTargetDocument(
    ruleName: Option[String] = None,
    fixedRate: Option[Double] = None,
    reservoirQuota: Option[NullableInteger] = None,
    reservoirQuotaTTL: Option[Timestamp] = None,
    interval: Option[NullableInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.SamplingTargetDocument = {
    import SamplingTargetDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.SamplingTargetDocument
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(fixedRate.map(value => value: java.lang.Double))(
        _.fixedRate
      )
      .optionallyWith(reservoirQuota.map(value => value: Integer))(
        _.reservoirQuota
      )
      .optionallyWith(
        reservoirQuotaTTL.map(value => Timestamp.unwrap(value): Instant)
      )(_.reservoirQuotaTTL)
      .optionallyWith(interval.map(value => value: Integer))(_.interval)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.SamplingTargetDocument.ReadOnly =
    zio.aws.xray.model.SamplingTargetDocument.wrap(buildAwsValue())
}
object SamplingTargetDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.SamplingTargetDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.SamplingTargetDocument =
      zio.aws.xray.model.SamplingTargetDocument(
        ruleName.map(value => value),
        fixedRate.map(value => value),
        reservoirQuota.map(value => value),
        reservoirQuotaTTL.map(value => value),
        interval.map(value => value)
      )
    def ruleName: Option[String]
    def fixedRate: Option[Double]
    def reservoirQuota: Option[NullableInteger]
    def reservoirQuotaTTL: Option[Timestamp]
    def interval: Option[NullableInteger]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getFixedRate: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedRate", fixedRate)
    def getReservoirQuota: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("reservoirQuota", reservoirQuota)
    def getReservoirQuotaTTL: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("reservoirQuotaTTL", reservoirQuotaTTL)
    def getInterval: ZIO[Any, AwsError, NullableInteger] =
      AwsError.unwrapOptionField("interval", interval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.SamplingTargetDocument
  ) extends zio.aws.xray.model.SamplingTargetDocument.ReadOnly {
    override val ruleName: Option[String] =
      scala.Option(impl.ruleName()).map(value => value: String)
    override val fixedRate: Option[Double] =
      scala.Option(impl.fixedRate()).map(value => value: Double)
    override val reservoirQuota: Option[NullableInteger] =
      scala.Option(impl.reservoirQuota()).map(value => value: NullableInteger)
    override val reservoirQuotaTTL: Option[Timestamp] = scala
      .Option(impl.reservoirQuotaTTL())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val interval: Option[NullableInteger] =
      scala.Option(impl.interval()).map(value => value: NullableInteger)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.SamplingTargetDocument
  ): zio.aws.xray.model.SamplingTargetDocument.ReadOnly = new Wrapper(impl)
}
