package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableDouble, NullableLong}
import scala.jdk.CollectionConverters._
final case class ServiceStatistics(
    okCount: Option[NullableLong] = None,
    errorStatistics: Option[zio.aws.xray.model.ErrorStatistics] = None,
    faultStatistics: Option[zio.aws.xray.model.FaultStatistics] = None,
    totalCount: Option[NullableLong] = None,
    totalResponseTime: Option[NullableDouble] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.ServiceStatistics = {
    import ServiceStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.ServiceStatistics
      .builder()
      .optionallyWith(okCount.map(value => value: java.lang.Long))(_.okCount)
      .optionallyWith(errorStatistics.map(value => value.buildAwsValue()))(
        _.errorStatistics
      )
      .optionallyWith(faultStatistics.map(value => value.buildAwsValue()))(
        _.faultStatistics
      )
      .optionallyWith(totalCount.map(value => value: java.lang.Long))(
        _.totalCount
      )
      .optionallyWith(totalResponseTime.map(value => value: java.lang.Double))(
        _.totalResponseTime
      )
      .build()
  }
  def asReadOnly: zio.aws.xray.model.ServiceStatistics.ReadOnly =
    zio.aws.xray.model.ServiceStatistics.wrap(buildAwsValue())
}
object ServiceStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.ServiceStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.ServiceStatistics =
      zio.aws.xray.model.ServiceStatistics(
        okCount.map(value => value),
        errorStatistics.map(value => value.asEditable),
        faultStatistics.map(value => value.asEditable),
        totalCount.map(value => value),
        totalResponseTime.map(value => value)
      )
    def okCount: Option[NullableLong]
    def errorStatistics: Option[zio.aws.xray.model.ErrorStatistics.ReadOnly]
    def faultStatistics: Option[zio.aws.xray.model.FaultStatistics.ReadOnly]
    def totalCount: Option[NullableLong]
    def totalResponseTime: Option[NullableDouble]
    def getOkCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("okCount", okCount)
    def getErrorStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.ErrorStatistics.ReadOnly] =
      AwsError.unwrapOptionField("errorStatistics", errorStatistics)
    def getFaultStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.FaultStatistics.ReadOnly] =
      AwsError.unwrapOptionField("faultStatistics", faultStatistics)
    def getTotalCount: ZIO[Any, AwsError, NullableLong] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getTotalResponseTime: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("totalResponseTime", totalResponseTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.ServiceStatistics
  ) extends zio.aws.xray.model.ServiceStatistics.ReadOnly {
    override val okCount: Option[NullableLong] =
      scala.Option(impl.okCount()).map(value => value: NullableLong)
    override val errorStatistics
        : Option[zio.aws.xray.model.ErrorStatistics.ReadOnly] = scala
      .Option(impl.errorStatistics())
      .map(value => zio.aws.xray.model.ErrorStatistics.wrap(value))
    override val faultStatistics
        : Option[zio.aws.xray.model.FaultStatistics.ReadOnly] = scala
      .Option(impl.faultStatistics())
      .map(value => zio.aws.xray.model.FaultStatistics.wrap(value))
    override val totalCount: Option[NullableLong] =
      scala.Option(impl.totalCount()).map(value => value: NullableLong)
    override val totalResponseTime: Option[NullableDouble] =
      scala.Option(impl.totalResponseTime()).map(value => value: NullableDouble)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.ServiceStatistics
  ): zio.aws.xray.model.ServiceStatistics.ReadOnly = new Wrapper(impl)
}
