package zio.aws.xray.model
import scala.jdk.CollectionConverters._
sealed trait TimeRangeType {
  def unwrap: software.amazon.awssdk.services.xray.model.TimeRangeType
}
object TimeRangeType {
  def wrap(
      value: software.amazon.awssdk.services.xray.model.TimeRangeType
  ): zio.aws.xray.model.TimeRangeType = value match {
    case software.amazon.awssdk.services.xray.model.TimeRangeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.xray.model.TimeRangeType.TRACE_ID =>
      val r = TraceId
      r
    case software.amazon.awssdk.services.xray.model.TimeRangeType.EVENT =>
      val r = Event
      r
  }
  case object unknownToSdkVersion extends zio.aws.xray.model.TimeRangeType {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.TimeRangeType =
      software.amazon.awssdk.services.xray.model.TimeRangeType.UNKNOWN_TO_SDK_VERSION
  }
  case object TraceId extends zio.aws.xray.model.TimeRangeType {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.TimeRangeType =
      software.amazon.awssdk.services.xray.model.TimeRangeType.TRACE_ID
  }
  case object Event extends zio.aws.xray.model.TimeRangeType {
    override def unwrap
        : software.amazon.awssdk.services.xray.model.TimeRangeType =
      software.amazon.awssdk.services.xray.model.TimeRangeType.EVENT
  }
}
