package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.Timestamp
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TimeSeriesServiceStatistics(
    timestamp: Option[Timestamp] = None,
    edgeSummaryStatistics: Option[zio.aws.xray.model.EdgeStatistics] = None,
    serviceSummaryStatistics: Option[zio.aws.xray.model.ServiceStatistics] =
      None,
    serviceForecastStatistics: Option[zio.aws.xray.model.ForecastStatistics] =
      None,
    responseTimeHistogram: Option[Iterable[zio.aws.xray.model.HistogramEntry]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics = {
    import TimeSeriesServiceStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        edgeSummaryStatistics.map(value => value.buildAwsValue())
      )(_.edgeSummaryStatistics)
      .optionallyWith(
        serviceSummaryStatistics.map(value => value.buildAwsValue())
      )(_.serviceSummaryStatistics)
      .optionallyWith(
        serviceForecastStatistics.map(value => value.buildAwsValue())
      )(_.serviceForecastStatistics)
      .optionallyWith(
        responseTimeHistogram.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseTimeHistogram)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly =
    zio.aws.xray.model.TimeSeriesServiceStatistics.wrap(buildAwsValue())
}
object TimeSeriesServiceStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.TimeSeriesServiceStatistics =
      zio.aws.xray.model.TimeSeriesServiceStatistics(
        timestamp.map(value => value),
        edgeSummaryStatistics.map(value => value.asEditable),
        serviceSummaryStatistics.map(value => value.asEditable),
        serviceForecastStatistics.map(value => value.asEditable),
        responseTimeHistogram.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def timestamp: Option[Timestamp]
    def edgeSummaryStatistics
        : Option[zio.aws.xray.model.EdgeStatistics.ReadOnly]
    def serviceSummaryStatistics
        : Option[zio.aws.xray.model.ServiceStatistics.ReadOnly]
    def serviceForecastStatistics
        : Option[zio.aws.xray.model.ForecastStatistics.ReadOnly]
    def responseTimeHistogram
        : Option[List[zio.aws.xray.model.HistogramEntry.ReadOnly]]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getEdgeSummaryStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.EdgeStatistics.ReadOnly] =
      AwsError.unwrapOptionField("edgeSummaryStatistics", edgeSummaryStatistics)
    def getServiceSummaryStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceStatistics.ReadOnly] =
      AwsError.unwrapOptionField(
        "serviceSummaryStatistics",
        serviceSummaryStatistics
      )
    def getServiceForecastStatistics
        : ZIO[Any, AwsError, zio.aws.xray.model.ForecastStatistics.ReadOnly] =
      AwsError.unwrapOptionField(
        "serviceForecastStatistics",
        serviceForecastStatistics
      )
    def getResponseTimeHistogram
        : ZIO[Any, AwsError, List[zio.aws.xray.model.HistogramEntry.ReadOnly]] =
      AwsError.unwrapOptionField("responseTimeHistogram", responseTimeHistogram)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics
  ) extends zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
    override val edgeSummaryStatistics
        : Option[zio.aws.xray.model.EdgeStatistics.ReadOnly] = scala
      .Option(impl.edgeSummaryStatistics())
      .map(value => zio.aws.xray.model.EdgeStatistics.wrap(value))
    override val serviceSummaryStatistics
        : Option[zio.aws.xray.model.ServiceStatistics.ReadOnly] = scala
      .Option(impl.serviceSummaryStatistics())
      .map(value => zio.aws.xray.model.ServiceStatistics.wrap(value))
    override val serviceForecastStatistics
        : Option[zio.aws.xray.model.ForecastStatistics.ReadOnly] = scala
      .Option(impl.serviceForecastStatistics())
      .map(value => zio.aws.xray.model.ForecastStatistics.wrap(value))
    override val responseTimeHistogram
        : Option[List[zio.aws.xray.model.HistogramEntry.ReadOnly]] = scala
      .Option(impl.responseTimeHistogram())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.HistogramEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.TimeSeriesServiceStatistics
  ): zio.aws.xray.model.TimeSeriesServiceStatistics.ReadOnly = new Wrapper(impl)
}
