package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{NullableBoolean, NullableDouble, TraceId}
import scala.jdk.CollectionConverters._
final case class Trace(
    id: Option[TraceId] = None,
    duration: Option[NullableDouble] = None,
    limitExceeded: Option[NullableBoolean] = None,
    segments: Option[Iterable[zio.aws.xray.model.Segment]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.Trace = {
    import Trace.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.Trace
      .builder()
      .optionallyWith(id.map(value => TraceId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(duration.map(value => value: java.lang.Double))(
        _.duration
      )
      .optionallyWith(limitExceeded.map(value => value: java.lang.Boolean))(
        _.limitExceeded
      )
      .optionallyWith(
        segments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segments)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.Trace.ReadOnly =
    zio.aws.xray.model.Trace.wrap(buildAwsValue())
}
object Trace {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.Trace] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.Trace = zio.aws.xray.model.Trace(
      id.map(value => value),
      duration.map(value => value),
      limitExceeded.map(value => value),
      segments.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def id: Option[TraceId]
    def duration: Option[NullableDouble]
    def limitExceeded: Option[NullableBoolean]
    def segments: Option[List[zio.aws.xray.model.Segment.ReadOnly]]
    def getId: ZIO[Any, AwsError, TraceId] =
      AwsError.unwrapOptionField("id", id)
    def getDuration: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("duration", duration)
    def getLimitExceeded: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("limitExceeded", limitExceeded)
    def getSegments
        : ZIO[Any, AwsError, List[zio.aws.xray.model.Segment.ReadOnly]] =
      AwsError.unwrapOptionField("segments", segments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.Trace
  ) extends zio.aws.xray.model.Trace.ReadOnly {
    override val id: Option[TraceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.xray.model.primitives.TraceId(value))
    override val duration: Option[NullableDouble] =
      scala.Option(impl.duration()).map(value => value: NullableDouble)
    override val limitExceeded: Option[NullableBoolean] =
      scala.Option(impl.limitExceeded()).map(value => value: NullableBoolean)
    override val segments: Option[List[zio.aws.xray.model.Segment.ReadOnly]] =
      scala
        .Option(impl.segments())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.Segment.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.Trace
  ): zio.aws.xray.model.Trace.ReadOnly = new Wrapper(impl)
}
