package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.xray.model.primitives.{
  AnnotationKey,
  Timestamp,
  NullableDouble,
  Integer,
  TraceId,
  NullableBoolean
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class TraceSummary(
    id: Option[TraceId] = None,
    duration: Option[NullableDouble] = None,
    responseTime: Option[NullableDouble] = None,
    hasFault: Option[NullableBoolean] = None,
    hasError: Option[NullableBoolean] = None,
    hasThrottle: Option[NullableBoolean] = None,
    isPartial: Option[NullableBoolean] = None,
    http: Option[zio.aws.xray.model.Http] = None,
    annotations: Option[
      Map[AnnotationKey, Iterable[zio.aws.xray.model.ValueWithServiceIds]]
    ] = None,
    users: Option[Iterable[zio.aws.xray.model.TraceUser]] = None,
    serviceIds: Option[Iterable[zio.aws.xray.model.ServiceId]] = None,
    resourceARNs: Option[Iterable[zio.aws.xray.model.ResourceARNDetail]] = None,
    instanceIds: Option[Iterable[zio.aws.xray.model.InstanceIdDetail]] = None,
    availabilityZones: Option[
      Iterable[zio.aws.xray.model.AvailabilityZoneDetail]
    ] = None,
    entryPoint: Option[zio.aws.xray.model.ServiceId] = None,
    faultRootCauses: Option[Iterable[zio.aws.xray.model.FaultRootCause]] = None,
    errorRootCauses: Option[Iterable[zio.aws.xray.model.ErrorRootCause]] = None,
    responseTimeRootCauses: Option[
      Iterable[zio.aws.xray.model.ResponseTimeRootCause]
    ] = None,
    revision: Option[Integer] = None,
    matchedEventTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.TraceSummary = {
    import TraceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.TraceSummary
      .builder()
      .optionallyWith(id.map(value => TraceId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(duration.map(value => value: java.lang.Double))(
        _.duration
      )
      .optionallyWith(responseTime.map(value => value: java.lang.Double))(
        _.responseTime
      )
      .optionallyWith(hasFault.map(value => value: java.lang.Boolean))(
        _.hasFault
      )
      .optionallyWith(hasError.map(value => value: java.lang.Boolean))(
        _.hasError
      )
      .optionallyWith(hasThrottle.map(value => value: java.lang.Boolean))(
        _.hasThrottle
      )
      .optionallyWith(isPartial.map(value => value: java.lang.Boolean))(
        _.isPartial
      )
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(
        annotations.map(value =>
          value
            .map({ case (key, value) =>
              (AnnotationKey.unwrap(key): java.lang.String) -> value.map {
                item =>
                  item.buildAwsValue()
              }.asJavaCollection
            })
            .asJava
        )
      )(_.annotations)
      .optionallyWith(
        users.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.users)
      .optionallyWith(
        serviceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceIds)
      .optionallyWith(
        resourceARNs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceARNs)
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(entryPoint.map(value => value.buildAwsValue()))(
        _.entryPoint
      )
      .optionallyWith(
        faultRootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.faultRootCauses)
      .optionallyWith(
        errorRootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errorRootCauses)
      .optionallyWith(
        responseTimeRootCauses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.responseTimeRootCauses)
      .optionallyWith(revision.map(value => value: java.lang.Integer))(
        _.revision
      )
      .optionallyWith(
        matchedEventTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.matchedEventTime)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.TraceSummary.ReadOnly =
    zio.aws.xray.model.TraceSummary.wrap(buildAwsValue())
}
object TraceSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.TraceSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.TraceSummary =
      zio.aws.xray.model.TraceSummary(
        id.map(value => value),
        duration.map(value => value),
        responseTime.map(value => value),
        hasFault.map(value => value),
        hasError.map(value => value),
        hasThrottle.map(value => value),
        isPartial.map(value => value),
        http.map(value => value.asEditable),
        annotations.map(value =>
          value.map({ case (key, value) =>
            key -> value.map { item =>
              item.asEditable
            }
          })
        ),
        users.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceARNs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZones.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        entryPoint.map(value => value.asEditable),
        faultRootCauses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errorRootCauses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        responseTimeRootCauses.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        revision.map(value => value),
        matchedEventTime.map(value => value)
      )
    def id: Option[TraceId]
    def duration: Option[NullableDouble]
    def responseTime: Option[NullableDouble]
    def hasFault: Option[NullableBoolean]
    def hasError: Option[NullableBoolean]
    def hasThrottle: Option[NullableBoolean]
    def isPartial: Option[NullableBoolean]
    def http: Option[zio.aws.xray.model.Http.ReadOnly]
    def annotations: Option[
      Map[AnnotationKey, List[zio.aws.xray.model.ValueWithServiceIds.ReadOnly]]
    ]
    def users: Option[List[zio.aws.xray.model.TraceUser.ReadOnly]]
    def serviceIds: Option[List[zio.aws.xray.model.ServiceId.ReadOnly]]
    def resourceARNs
        : Option[List[zio.aws.xray.model.ResourceARNDetail.ReadOnly]]
    def instanceIds: Option[List[zio.aws.xray.model.InstanceIdDetail.ReadOnly]]
    def availabilityZones
        : Option[List[zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly]]
    def entryPoint: Option[zio.aws.xray.model.ServiceId.ReadOnly]
    def faultRootCauses
        : Option[List[zio.aws.xray.model.FaultRootCause.ReadOnly]]
    def errorRootCauses
        : Option[List[zio.aws.xray.model.ErrorRootCause.ReadOnly]]
    def responseTimeRootCauses
        : Option[List[zio.aws.xray.model.ResponseTimeRootCause.ReadOnly]]
    def revision: Option[Integer]
    def matchedEventTime: Option[Timestamp]
    def getId: ZIO[Any, AwsError, TraceId] =
      AwsError.unwrapOptionField("id", id)
    def getDuration: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("duration", duration)
    def getResponseTime: ZIO[Any, AwsError, NullableDouble] =
      AwsError.unwrapOptionField("responseTime", responseTime)
    def getHasFault: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("hasFault", hasFault)
    def getHasError: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("hasError", hasError)
    def getHasThrottle: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("hasThrottle", hasThrottle)
    def getIsPartial: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("isPartial", isPartial)
    def getHttp: ZIO[Any, AwsError, zio.aws.xray.model.Http.ReadOnly] =
      AwsError.unwrapOptionField("http", http)
    def getAnnotations: ZIO[Any, AwsError, Map[AnnotationKey, List[
      zio.aws.xray.model.ValueWithServiceIds.ReadOnly
    ]]] = AwsError.unwrapOptionField("annotations", annotations)
    def getUsers
        : ZIO[Any, AwsError, List[zio.aws.xray.model.TraceUser.ReadOnly]] =
      AwsError.unwrapOptionField("users", users)
    def getServiceIds
        : ZIO[Any, AwsError, List[zio.aws.xray.model.ServiceId.ReadOnly]] =
      AwsError.unwrapOptionField("serviceIds", serviceIds)
    def getResourceARNs: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ResourceARNDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceARNs", resourceARNs)
    def getInstanceIds: ZIO[Any, AwsError, List[
      zio.aws.xray.model.InstanceIdDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getAvailabilityZones: ZIO[Any, AwsError, List[
      zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly
    ]] = AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getEntryPoint
        : ZIO[Any, AwsError, zio.aws.xray.model.ServiceId.ReadOnly] =
      AwsError.unwrapOptionField("entryPoint", entryPoint)
    def getFaultRootCauses
        : ZIO[Any, AwsError, List[zio.aws.xray.model.FaultRootCause.ReadOnly]] =
      AwsError.unwrapOptionField("faultRootCauses", faultRootCauses)
    def getErrorRootCauses
        : ZIO[Any, AwsError, List[zio.aws.xray.model.ErrorRootCause.ReadOnly]] =
      AwsError.unwrapOptionField("errorRootCauses", errorRootCauses)
    def getResponseTimeRootCauses: ZIO[Any, AwsError, List[
      zio.aws.xray.model.ResponseTimeRootCause.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "responseTimeRootCauses",
      responseTimeRootCauses
    )
    def getRevision: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("revision", revision)
    def getMatchedEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("matchedEventTime", matchedEventTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.TraceSummary
  ) extends zio.aws.xray.model.TraceSummary.ReadOnly {
    override val id: Option[TraceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.xray.model.primitives.TraceId(value))
    override val duration: Option[NullableDouble] =
      scala.Option(impl.duration()).map(value => value: NullableDouble)
    override val responseTime: Option[NullableDouble] =
      scala.Option(impl.responseTime()).map(value => value: NullableDouble)
    override val hasFault: Option[NullableBoolean] =
      scala.Option(impl.hasFault()).map(value => value: NullableBoolean)
    override val hasError: Option[NullableBoolean] =
      scala.Option(impl.hasError()).map(value => value: NullableBoolean)
    override val hasThrottle: Option[NullableBoolean] =
      scala.Option(impl.hasThrottle()).map(value => value: NullableBoolean)
    override val isPartial: Option[NullableBoolean] =
      scala.Option(impl.isPartial()).map(value => value: NullableBoolean)
    override val http: Option[zio.aws.xray.model.Http.ReadOnly] = scala
      .Option(impl.http())
      .map(value => zio.aws.xray.model.Http.wrap(value))
    override val annotations: Option[
      Map[AnnotationKey, List[zio.aws.xray.model.ValueWithServiceIds.ReadOnly]]
    ] = scala
      .Option(impl.annotations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.xray.model.primitives
              .AnnotationKey(key) -> value.asScala.map { item =>
              zio.aws.xray.model.ValueWithServiceIds.wrap(item)
            }.toList
          })
          .toMap
      )
    override val users: Option[List[zio.aws.xray.model.TraceUser.ReadOnly]] =
      scala
        .Option(impl.users())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.TraceUser.wrap(item)
          }.toList
        )
    override val serviceIds
        : Option[List[zio.aws.xray.model.ServiceId.ReadOnly]] = scala
      .Option(impl.serviceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.ServiceId.wrap(item)
        }.toList
      )
    override val resourceARNs
        : Option[List[zio.aws.xray.model.ResourceARNDetail.ReadOnly]] = scala
      .Option(impl.resourceARNs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.ResourceARNDetail.wrap(item)
        }.toList
      )
    override val instanceIds
        : Option[List[zio.aws.xray.model.InstanceIdDetail.ReadOnly]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.InstanceIdDetail.wrap(item)
        }.toList
      )
    override val availabilityZones
        : Option[List[zio.aws.xray.model.AvailabilityZoneDetail.ReadOnly]] =
      scala
        .Option(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.AvailabilityZoneDetail.wrap(item)
          }.toList
        )
    override val entryPoint: Option[zio.aws.xray.model.ServiceId.ReadOnly] =
      scala
        .Option(impl.entryPoint())
        .map(value => zio.aws.xray.model.ServiceId.wrap(value))
    override val faultRootCauses
        : Option[List[zio.aws.xray.model.FaultRootCause.ReadOnly]] = scala
      .Option(impl.faultRootCauses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.FaultRootCause.wrap(item)
        }.toList
      )
    override val errorRootCauses
        : Option[List[zio.aws.xray.model.ErrorRootCause.ReadOnly]] = scala
      .Option(impl.errorRootCauses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.ErrorRootCause.wrap(item)
        }.toList
      )
    override val responseTimeRootCauses
        : Option[List[zio.aws.xray.model.ResponseTimeRootCause.ReadOnly]] =
      scala
        .Option(impl.responseTimeRootCauses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.xray.model.ResponseTimeRootCause.wrap(item)
          }.toList
        )
    override val revision: Option[Integer] =
      scala.Option(impl.revision()).map(value => value: Integer)
    override val matchedEventTime: Option[Timestamp] = scala
      .Option(impl.matchedEventTime())
      .map(value => zio.aws.xray.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.TraceSummary
  ): zio.aws.xray.model.TraceSummary.ReadOnly = new Wrapper(impl)
}
