package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TraceUser(
    userName: Option[String] = None,
    serviceIds: Option[Iterable[zio.aws.xray.model.ServiceId]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.xray.model.TraceUser = {
    import TraceUser.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.TraceUser
      .builder()
      .optionallyWith(userName.map(value => value: java.lang.String))(
        _.userName
      )
      .optionallyWith(
        serviceIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceIds)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.TraceUser.ReadOnly =
    zio.aws.xray.model.TraceUser.wrap(buildAwsValue())
}
object TraceUser {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.xray.model.TraceUser] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.TraceUser = zio.aws.xray.model.TraceUser(
      userName.map(value => value),
      serviceIds.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def userName: Option[String]
    def serviceIds: Option[List[zio.aws.xray.model.ServiceId.ReadOnly]]
    def getUserName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userName", userName)
    def getServiceIds
        : ZIO[Any, AwsError, List[zio.aws.xray.model.ServiceId.ReadOnly]] =
      AwsError.unwrapOptionField("serviceIds", serviceIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.TraceUser
  ) extends zio.aws.xray.model.TraceUser.ReadOnly {
    override val userName: Option[String] =
      scala.Option(impl.userName()).map(value => value: String)
    override val serviceIds
        : Option[List[zio.aws.xray.model.ServiceId.ReadOnly]] = scala
      .Option(impl.serviceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.xray.model.ServiceId.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.TraceUser
  ): zio.aws.xray.model.TraceUser.ReadOnly = new Wrapper(impl)
}
