package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnprocessedStatistics(
    ruleName: Option[String] = None,
    errorCode: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UnprocessedStatistics = {
    import UnprocessedStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UnprocessedStatistics
      .builder()
      .optionallyWith(ruleName.map(value => value: java.lang.String))(
        _.ruleName
      )
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UnprocessedStatistics.ReadOnly =
    zio.aws.xray.model.UnprocessedStatistics.wrap(buildAwsValue())
}
object UnprocessedStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UnprocessedStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UnprocessedStatistics =
      zio.aws.xray.model.UnprocessedStatistics(
        ruleName.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def ruleName: Option[String]
    def errorCode: Option[String]
    def message: Option[String]
    def getRuleName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UnprocessedStatistics
  ) extends zio.aws.xray.model.UnprocessedStatistics.ReadOnly {
    override val ruleName: Option[String] =
      scala.Option(impl.ruleName()).map(value => value: String)
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UnprocessedStatistics
  ): zio.aws.xray.model.UnprocessedStatistics.ReadOnly = new Wrapper(impl)
}
