package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnprocessedTraceSegment(
    id: Option[String] = None,
    errorCode: Option[String] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment = {
    import UnprocessedTraceSegment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UnprocessedTraceSegment.ReadOnly =
    zio.aws.xray.model.UnprocessedTraceSegment.wrap(buildAwsValue())
}
object UnprocessedTraceSegment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UnprocessedTraceSegment =
      zio.aws.xray.model.UnprocessedTraceSegment(
        id.map(value => value),
        errorCode.map(value => value),
        message.map(value => value)
      )
    def id: Option[String]
    def errorCode: Option[String]
    def message: Option[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment
  ) extends zio.aws.xray.model.UnprocessedTraceSegment.ReadOnly {
    override val id: Option[String] =
      scala.Option(impl.id()).map(value => value: String)
    override val errorCode: Option[String] =
      scala.Option(impl.errorCode()).map(value => value: String)
    override val message: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UnprocessedTraceSegment
  ): zio.aws.xray.model.UnprocessedTraceSegment.ReadOnly = new Wrapper(impl)
}
