package zio.aws.xray.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.xray.model.primitives.{TagKey, AmazonResourceName}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.xray.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.xray.model.UntagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.xray.model.UntagResourceRequest.ReadOnly =
    zio.aws.xray.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.xray.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.xray.model.UntagResourceRequest =
      zio.aws.xray.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: AmazonResourceName
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.xray.model.UntagResourceRequest
  ) extends zio.aws.xray.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.xray.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.xray.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.xray.model.UntagResourceRequest
  ): zio.aws.xray.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
